/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.json;

import java.util.ArrayList;
import java.util.List;
import org.apache.sqoop.classification.InterfaceAudience;
import org.apache.sqoop.classification.InterfaceStability;
import org.apache.sqoop.json.JsonBean;
import org.apache.sqoop.model.MRole;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class RoleBean
implements JsonBean {
    public static final String ROLE = "role";
    private static final String NAME = "name";
    private List<MRole> roles;

    public List<MRole> getRoles() {
        return this.roles;
    }

    public RoleBean(MRole role) {
        this();
        this.roles = new ArrayList<MRole>();
        this.roles.add(role);
    }

    public RoleBean(List<MRole> roles) {
        this();
        this.roles = roles;
    }

    public RoleBean() {
    }

    @Override
    public JSONObject extract(boolean skipSensitive) {
        JSONObject role = new JSONObject();
        role.put((Object)ROLE, (Object)this.extractRole(this.roles.get(0)));
        return role;
    }

    protected JSONArray extractRoles() {
        JSONArray rolesArray = new JSONArray();
        if (this.roles != null) {
            for (MRole role : this.roles) {
                rolesArray.add((Object)this.extractRole(role));
            }
        }
        return rolesArray;
    }

    private JSONObject extractRole(MRole role) {
        JSONObject object = new JSONObject();
        object.put((Object)NAME, (Object)role.getName());
        return object;
    }

    @Override
    public void restore(JSONObject json) {
        this.roles = new ArrayList<MRole>();
        JSONObject obj = (JSONObject)json.get((Object)ROLE);
        this.roles.add(this.restoreRole(obj));
    }

    protected void restoreRoles(JSONArray array) {
        this.roles = new ArrayList<MRole>();
        for (Object obj : array) {
            this.roles.add(this.restoreRole(obj));
        }
    }

    private MRole restoreRole(Object obj) {
        JSONObject object = (JSONObject)obj;
        return new MRole((String)object.get((Object)NAME));
    }
}

