/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.validation.validators;

import org.apache.sqoop.validation.Message;
import org.apache.sqoop.validation.Status;
import org.apache.sqoop.validation.validators.AbstractValidator;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

public class TestValidator {
    @Test
    public void test() {
        ValidatorImpl validator = new ValidatorImpl();
        AssertJUnit.assertEquals((int)0, (int)validator.getMessages().size());
        validator.validate("X");
        AssertJUnit.assertEquals((int)2, (int)validator.getMessages().size());
        Message msg = (Message)validator.getMessages().get(0);
        AssertJUnit.assertEquals((Object)Status.OK, (Object)msg.getStatus());
        AssertJUnit.assertEquals((String)"X", (String)msg.getMessage());
        msg = (Message)validator.getMessages().get(1);
        AssertJUnit.assertEquals((Object)Status.ERROR, (Object)msg.getStatus());
        AssertJUnit.assertEquals((String)"Prefix: X", (String)msg.getMessage());
        validator.reset();
        AssertJUnit.assertEquals((int)0, (int)validator.getMessages().size());
    }

    public static class ValidatorImpl
    extends AbstractValidator<String> {
        public void validate(String msg) {
            this.addMessage(Status.OK, msg);
            this.addMessage(new Message(Status.ERROR, "Prefix: " + msg));
        }
    }
}

