/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.validation.validators;

import org.apache.sqoop.validation.Status;
import org.apache.sqoop.validation.validators.AbstractValidator;
import org.apache.sqoop.validation.validators.HostAndPortValidator;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestHostAndPortValidator {
    AbstractValidator<String> validator = new HostAndPortValidator();

    @BeforeMethod(alwaysRun=true)
    public void setUp() {
        this.validator.reset();
        AssertJUnit.assertEquals((int)0, (int)this.validator.getMessages().size());
    }

    @Test
    public void testValidHostAndPort() {
        this.expectValid("host1:8020");
    }

    @Test
    public void testValidHost() {
        this.expectValid("host1");
    }

    private void expectValid(String input) {
        this.validator.validate((Object)input);
        AssertJUnit.assertEquals((Object)Status.OK, (Object)this.validator.getStatus());
        AssertJUnit.assertEquals((int)0, (int)this.validator.getMessages().size());
    }

    @Test
    public void testInvalidPort() {
        this.expectInvalid("host1:invalid_port");
    }

    @Test
    public void testNegativePort() {
        this.expectInvalid("host1:-1");
    }

    @Test
    public void testHostNameWithInvalidChars() {
        this.expectInvalid("hostname has space:8020");
    }

    private void expectInvalid(String input) {
        this.validator.validate((Object)input);
        AssertJUnit.assertEquals((Object)Status.ERROR, (Object)this.validator.getStatus());
        AssertJUnit.assertEquals((int)1, (int)this.validator.getMessages().size());
    }
}

