/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.validation.validators;

import com.google.common.io.Files;
import java.io.File;
import org.apache.sqoop.validation.Status;
import org.apache.sqoop.validation.validators.AbstractValidator;
import org.apache.sqoop.validation.validators.DirectoryExistsValidator;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestDirectoryExistsValidator {
    AbstractValidator<String> validator = new DirectoryExistsValidator();

    @BeforeMethod(alwaysRun=true)
    public void setUp() {
        this.validator.reset();
        Assert.assertEquals((int)0, (int)this.validator.getMessages().size());
    }

    @Test
    public void testNull() {
        this.validator.validate(null);
        Assert.assertEquals((Object)Status.OK, (Object)this.validator.getStatus());
    }

    @Test
    public void testEmpty() {
        this.validator.validate((Object)"");
        Assert.assertEquals((Object)Status.OK, (Object)this.validator.getStatus());
    }

    @Test
    public void testExistingDirectory() {
        File tmpDir = Files.createTempDir();
        tmpDir.deleteOnExit();
        this.validator.validate((Object)tmpDir.getAbsolutePath());
        Assert.assertEquals((Object)Status.OK, (Object)this.validator.getStatus());
    }

    @Test
    public void testFileInsteadOfDirectory() throws Exception {
        File tmpDir = File.createTempFile("ABCDEFG", "12345");
        tmpDir.createNewFile();
        tmpDir.deleteOnExit();
        this.validator.validate((Object)tmpDir.getAbsolutePath());
        Assert.assertEquals((Object)Status.ERROR, (Object)this.validator.getStatus());
        Assert.assertEquals((int)1, (int)this.validator.getMessages().size());
    }

    @Test
    public void testNonExistingPath() throws Exception {
        this.validator.validate((Object)"/X/Y/Z/This/Can/Not/Exists/Right/Question-mark");
        Assert.assertEquals((Object)Status.ERROR, (Object)this.validator.getStatus());
        Assert.assertEquals((int)1, (int)this.validator.getMessages().size());
    }
}

