/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.validation;

import java.util.List;
import org.apache.sqoop.model.Config;
import org.apache.sqoop.model.ConfigClass;
import org.apache.sqoop.model.ConfigurationClass;
import org.apache.sqoop.model.Input;
import org.apache.sqoop.model.Validator;
import org.apache.sqoop.validation.ConfigValidationResult;
import org.apache.sqoop.validation.ConfigValidationRunner;
import org.apache.sqoop.validation.Status;
import org.apache.sqoop.validation.validators.AbstractValidator;
import org.apache.sqoop.validation.validators.Contains;
import org.apache.sqoop.validation.validators.NotEmpty;
import org.apache.sqoop.validation.validators.NotNull;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

public class TestValidationRunner {
    @Test
    public void testValidateConfig() {
        ConfigA config = new ConfigA();
        ConfigValidationRunner runner = new ConfigValidationRunner();
        config.notNull = null;
        ConfigValidationResult result = runner.validateConfig("configName", (Object)config);
        AssertJUnit.assertEquals((Object)Status.ERROR, (Object)result.getStatus());
        AssertJUnit.assertEquals((int)1, (int)result.getMessages().size());
        Assert.assertTrue((boolean)result.getMessages().containsKey("configName.notNull"));
        config.notNull = "error";
        result = runner.validateConfig("configName", (Object)config);
        AssertJUnit.assertEquals((Object)Status.ERROR, (Object)result.getStatus());
        AssertJUnit.assertEquals((int)1, (int)result.getMessages().size());
        Assert.assertTrue((boolean)result.getMessages().containsKey("configName"));
        config.notNull = "This is truly random string";
        result = runner.validateConfig("configName", (Object)config);
        AssertJUnit.assertEquals((Object)Status.OK, (Object)result.getStatus());
        AssertJUnit.assertEquals((int)0, (int)result.getMessages().size());
    }

    @Test
    public void testMultipleValidatorsOnSingleInput() {
        ConfigB config = new ConfigB();
        ConfigValidationRunner runner = new ConfigValidationRunner();
        config.str = null;
        ConfigValidationResult result = runner.validateConfig("configName", (Object)config);
        AssertJUnit.assertEquals((Object)Status.ERROR, (Object)result.getStatus());
        AssertJUnit.assertEquals((int)1, (int)result.getMessages().size());
        Assert.assertTrue((boolean)result.getMessages().containsKey("configName.str"));
        AssertJUnit.assertEquals((int)2, (int)((List)result.getMessages().get("configName.str")).size());
    }

    @Test
    public void testValidatorWithParameters() {
        ConfigC config = new ConfigC();
        ConfigValidationRunner runner = new ConfigValidationRunner();
        config.str = "Mordor";
        ConfigValidationResult result = runner.validateConfig("configName", (Object)config);
        AssertJUnit.assertEquals((Object)Status.ERROR, (Object)result.getStatus());
        AssertJUnit.assertEquals((int)1, (int)result.getMessages().size());
        Assert.assertTrue((boolean)result.getMessages().containsKey("configName.str"));
        config.str = "Morfindmedor";
        result = runner.validateConfig("configName", (Object)config);
        AssertJUnit.assertEquals((Object)Status.OK, (Object)result.getStatus());
        AssertJUnit.assertEquals((int)0, (int)result.getMessages().size());
    }

    @Test
    public void testValidate() {
        ConfigurationA conf = new ConfigurationA();
        ConfigValidationRunner runner = new ConfigValidationRunner();
        conf.formA.notNull = null;
        ConfigValidationResult result = runner.validate((Object)conf);
        AssertJUnit.assertEquals((Object)Status.ERROR, (Object)result.getStatus());
        AssertJUnit.assertEquals((int)1, (int)result.getMessages().size());
        Assert.assertTrue((boolean)result.getMessages().containsKey("formA.notNull"));
        conf.formA.notNull = "error";
        result = runner.validate((Object)conf);
        AssertJUnit.assertEquals((Object)Status.ERROR, (Object)result.getStatus());
        AssertJUnit.assertEquals((int)1, (int)result.getMessages().size());
        Assert.assertTrue((boolean)result.getMessages().containsKey("formA"));
        conf.formA.notNull = "conf-error";
        result = runner.validate((Object)conf);
        AssertJUnit.assertEquals((Object)Status.ERROR, (Object)result.getStatus());
        AssertJUnit.assertEquals((int)1, (int)result.getMessages().size());
        Assert.assertTrue((boolean)result.getMessages().containsKey(""));
        conf.formA.notNull = "Valid string";
        result = runner.validate((Object)conf);
        AssertJUnit.assertEquals((Object)Status.OK, (Object)result.getStatus());
        AssertJUnit.assertEquals((int)0, (int)result.getMessages().size());
    }

    @ConfigurationClass(validators={@Validator(value=ClassValidator.class)})
    public static class ConfigurationA {
        @Config
        ConfigA formA = new ConfigA();

        public static class ClassValidator
        extends AbstractValidator<ConfigurationA> {
            public void validate(ConfigurationA conf) {
                if ("error".equals(conf.formA.notNull)) {
                    this.addMessage(Status.ERROR, "error");
                }
                if ("conf-error".equals(conf.formA.notNull)) {
                    this.addMessage(Status.ERROR, "conf-error");
                }
            }
        }
    }

    @ConfigClass
    public static class ConfigC {
        @Input(validators={@Validator(value=Contains.class, strArg="findme")})
        String str;
    }

    @ConfigClass
    public static class ConfigB {
        @Input(validators={@Validator(value=NotNull.class), @Validator(value=NotEmpty.class)})
        String str;
    }

    @ConfigClass(validators={@Validator(value=ConfigValidator.class)})
    public static class ConfigA {
        @Input(validators={@Validator(value=NotNull.class)})
        String notNull;

        public static class ConfigValidator
        extends AbstractValidator<ConfigA> {
            public void validate(ConfigA config) {
                if (config.notNull == null) {
                    this.addMessage(Status.ERROR, "null");
                }
                if ("error".equals(config.notNull)) {
                    this.addMessage(Status.ERROR, "error");
                }
            }
        }
    }
}

