/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.utils;

import org.apache.sqoop.utils.ClassUtils;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

public class TestClassUtils {
    @Test
    public void testLoadClass() {
        Assert.assertNull((Object)ClassUtils.loadClass((String)"A"));
        AssertJUnit.assertEquals(A.class, (Object)ClassUtils.loadClass((String)A.class.getName()));
    }

    @Test
    public void testInstantiateNull() {
        Assert.assertNull((Object)ClassUtils.instantiate((Class)null, (Object[])new Object[0]));
    }

    @Test
    public void testInstantiate() {
        A a = (A)ClassUtils.instantiate(A.class, (Object[])new Object[]{"a"});
        Assert.assertNotNull((Object)a);
        AssertJUnit.assertEquals((int)1, (int)a.num);
        AssertJUnit.assertEquals((String)"a", (String)a.a);
        A b = (A)ClassUtils.instantiate(A.class, (Object[])new Object[]{"b", 3, 5});
        Assert.assertNotNull((Object)b);
        AssertJUnit.assertEquals((int)3, (int)b.num);
        AssertJUnit.assertEquals((String)"b", (String)b.a);
        AssertJUnit.assertEquals((int)3, (int)b.b);
        AssertJUnit.assertEquals((int)5, (int)b.c);
        Primitive p = (Primitive)ClassUtils.instantiate(Primitive.class, (Object[])new Object[]{1, Float.valueOf(1.0f), true});
        Assert.assertNotNull((Object)p);
        AssertJUnit.assertEquals((int)1, (int)p.i);
        AssertJUnit.assertEquals((float)1.0f, (float)p.f, (float)0.0f);
        AssertJUnit.assertEquals((boolean)true, (boolean)p.b);
        A c = (A)ClassUtils.instantiate(A.class, (Object[])new Object[]{new Child()});
        Assert.assertNotNull((Object)c);
        Assert.assertNotNull((Object)c.p);
        AssertJUnit.assertEquals(Child.class, c.p.getClass());
    }

    @Test
    public void testGetEnumStrings() {
        Assert.assertNull((Object)ClassUtils.getEnumStrings(A.class));
        AssertJUnit.assertArrayEquals((Object[])new String[]{"A", "B", "C"}, (Object[])ClassUtils.getEnumStrings(EnumA.class));
        AssertJUnit.assertArrayEquals((Object[])new String[]{"X", "Y"}, (Object[])ClassUtils.getEnumStrings(EnumX.class));
    }

    static enum EnumA {
        A,
        B,
        C;

    }

    static enum EnumX {
        X,
        Y;

    }

    public static class Primitive {
        int i;
        float f;
        boolean b;

        public Primitive(int i, float f, boolean b) {
            this.i = i;
            this.f = f;
            this.b = b;
        }
    }

    public static class A {
        String a;
        int b;
        int c;
        int num;
        Parent p;

        public A(String a) {
            this.num = 1;
            this.a = a;
        }

        public A(String a, Integer b, Integer c) {
            this(a);
            this.num = 3;
            this.b = b;
            this.c = c;
        }

        public A(Parent p) {
            this.p = p;
        }
    }

    public static class Child
    extends Parent {
    }

    public static class Parent {
    }
}

