/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.schema.type;

import org.apache.sqoop.schema.type.Array;
import org.apache.sqoop.schema.type.Binary;
import org.apache.sqoop.schema.type.Column;
import org.apache.sqoop.schema.type.Text;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestArray {
    @Test
    public void testArrayWithSameListType() {
        Array a1 = new Array("A", (Column)new Text("T"));
        Array a2 = new Array("A", (Column)new Text("T"));
        Assert.assertTrue((boolean)a1.equals((Object)a2));
        Assert.assertEquals((String)a1.toString(), (String)a2.toString());
    }

    @Test
    public void testArrayWithDifferentName() {
        Array a1 = new Array("A", (Column)new Text("T"));
        Array a2 = new Array("B", (Column)new Text("T"));
        Assert.assertFalse((boolean)a1.equals((Object)a2));
        Assert.assertNotEquals((Object)a1.toString(), (Object)a2.toString());
    }

    @Test
    public void testArrayWithDifferentSize() {
        Array a1 = new Array("A", (Column)new Text("T")).setSize(Long.valueOf(22L));
        Array a2 = new Array("A", (Column)new Text("T")).setSize(Long.valueOf(2333L));
        Assert.assertFalse((boolean)a1.equals((Object)a2));
        Assert.assertNotEquals((Object)a1.toString(), (Object)a2.toString());
    }

    @Test
    public void testArrayWithDifferentListType() {
        Array a1 = new Array("A", (Column)new Text("T"));
        Array a2 = new Array("A", (Column)new Binary("B"));
        Assert.assertFalse((boolean)a1.equals((Object)a2));
        Assert.assertNotEquals((Object)a1.toString(), (Object)a2.toString());
    }
}

