/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.model;

import org.apache.sqoop.model.InputEditable;
import org.apache.sqoop.model.MInputType;
import org.apache.sqoop.model.MStringInput;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestMStringInput {
    @Test
    public void testInitialization() {
        short len = 6;
        MStringInput input = new MStringInput("sqoopsqoop", true, InputEditable.ANY, "", len);
        Assert.assertEquals((String)"sqoopsqoop", (String)input.getName());
        Assert.assertEquals((boolean)true, (boolean)input.isSensitive());
        Assert.assertEquals((short)len, (short)input.getMaxLength());
        Assert.assertEquals((Object)MInputType.STRING, (Object)input.getType());
    }

    @Test
    public void testEquals() {
        short len = 6;
        MStringInput input1 = new MStringInput("sqoopsqoop", true, InputEditable.ANY, "", len);
        MStringInput input2 = new MStringInput("sqoopsqoop", true, InputEditable.ANY, "", len);
        Assert.assertTrue((boolean)input1.equals((Object)input2));
        MStringInput input3 = new MStringInput("sqoopsqoop", false, InputEditable.ANY, "", len);
        MStringInput input4 = new MStringInput("sqoopsqoop", true, InputEditable.ANY, "", len);
        Assert.assertFalse((boolean)input3.equals((Object)input4));
    }

    @Test
    public void testValue() {
        MStringInput input1 = new MStringInput("sqoopsqoop", true, InputEditable.ANY, "", 5);
        input1.setValue((Object)"sqoop");
        Assert.assertEquals((String)"sqoop", (String)((String)input1.getValue()));
        input1.setEmpty();
        Assert.assertNull((Object)input1.getValue());
    }

    @Test
    public void testUrlSafe() {
        MStringInput input1 = new MStringInput("sqoopsqoop", true, InputEditable.ANY, "", 5);
        String s = "Sqoop%$!@#&*()Sqoop";
        input1.setValue((Object)s);
        String tmp = input1.getUrlSafeValueString();
        input1.restoreFromUrlSafeValueString(tmp);
        Assert.assertEquals((String)s, (String)((String)input1.getValue()));
    }

    @Test
    public void testNamedElement() {
        MStringInput input1 = new MStringInput("sqoopsqoop", true, InputEditable.ANY, "", 5);
        Assert.assertEquals((String)"sqoopsqoop.label", (String)input1.getLabelKey());
        Assert.assertEquals((String)"sqoopsqoop.help", (String)input1.getHelpKey());
    }
}

