/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.model;

import java.util.ArrayList;
import org.apache.sqoop.model.InputEditable;
import org.apache.sqoop.model.MConfig;
import org.apache.sqoop.model.MIntegerInput;
import org.apache.sqoop.model.MLink;
import org.apache.sqoop.model.MLinkConfig;
import org.apache.sqoop.model.MStringInput;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestMLink {
    @Test
    public void testInitialization() {
        MLink link = this.link();
        Assert.assertEquals((long)123L, (long)link.getConnectorId());
        Assert.assertEquals((String)"Vampire", (String)link.getName());
        Assert.assertEquals((String)"Buffy", (String)link.getCreationUser());
        Assert.assertEquals((Object)this.linkConfig(), (Object)link.getConnectorLinkConfig());
        MLink copy = new MLink(link);
        Assert.assertEquals((long)123L, (long)copy.getConnectorId());
        Assert.assertEquals((String)"Vampire", (String)copy.getName());
        Assert.assertEquals((String)"Buffy", (String)copy.getCreationUser());
        Assert.assertEquals((Object)link.getCreationDate(), (Object)copy.getCreationDate());
        Assert.assertEquals((Object)this.linkConfig(), (Object)copy.getConnectorLinkConfig());
    }

    @Test
    public void testClone() {
        MLink link = this.link();
        MLink withoutLinkValue = link.clone(false);
        Assert.assertEquals((Object)link, (Object)withoutLinkValue);
        Assert.assertEquals((long)-1L, (long)withoutLinkValue.getPersistenceId());
        Assert.assertNull((Object)withoutLinkValue.getName());
        Assert.assertNull((Object)withoutLinkValue.getCreationUser());
        Assert.assertEquals((Object)this.linkConfig(), (Object)withoutLinkValue.getConnectorLinkConfig());
        Assert.assertNull((Object)withoutLinkValue.getConnectorLinkConfig().getConfig("CONFIGNAME").getInput("INTEGER-INPUT").getValue());
        Assert.assertNull((Object)withoutLinkValue.getConnectorLinkConfig().getConfig("CONFIGNAME").getInput("STRING-INPUT").getValue());
        MLink withLinkValue = link.clone(true);
        Assert.assertEquals((Object)link, (Object)withLinkValue);
        Assert.assertEquals((long)link.getPersistenceId(), (long)withLinkValue.getPersistenceId());
        Assert.assertEquals((String)link.getName(), (String)withLinkValue.getName());
        Assert.assertEquals((String)link.getCreationUser(), (String)withLinkValue.getCreationUser());
        Assert.assertEquals((Object)this.linkConfig(), (Object)withLinkValue.getConnectorLinkConfig());
        Assert.assertEquals((Object)100, (Object)withLinkValue.getConnectorLinkConfig().getConfig("CONFIGNAME").getInput("INTEGER-INPUT").getValue());
        Assert.assertEquals((Object)"TEST-VALUE", (Object)withLinkValue.getConnectorLinkConfig().getConfig("CONFIGNAME").getInput("STRING-INPUT").getValue());
    }

    private MLink link() {
        MLink link = new MLink(123L, this.linkConfig());
        link.setName("Vampire");
        link.setCreationUser("Buffy");
        return link;
    }

    private MLinkConfig linkConfig() {
        ArrayList<MConfig> configs = new ArrayList<MConfig>();
        MIntegerInput input = new MIntegerInput("INTEGER-INPUT", false, InputEditable.ANY, "");
        input.setValue((Object)100);
        MStringInput strInput = new MStringInput("STRING-INPUT", false, InputEditable.ANY, "", 20);
        strInput.setValue((Object)"TEST-VALUE");
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(input);
        list.add(strInput);
        MConfig config = new MConfig("CONFIGNAME", list);
        configs.add(config);
        return new MLinkConfig(configs);
    }
}

