/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.model;

import java.util.ArrayList;
import org.apache.sqoop.model.InputEditable;
import org.apache.sqoop.model.MConfig;
import org.apache.sqoop.model.MDriverConfig;
import org.apache.sqoop.model.MFromConfig;
import org.apache.sqoop.model.MIntegerInput;
import org.apache.sqoop.model.MJob;
import org.apache.sqoop.model.MLongInput;
import org.apache.sqoop.model.MMapInput;
import org.apache.sqoop.model.MStringInput;
import org.apache.sqoop.model.MToConfig;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

public class TestMJob {
    @Test
    public void testInitialization() {
        MJob job = this.job();
        AssertJUnit.assertEquals((long)123L, (long)job.getFromConnectorId());
        AssertJUnit.assertEquals((long)456L, (long)job.getToConnectorId());
        AssertJUnit.assertEquals((String)"Buffy", (String)job.getCreationUser());
        AssertJUnit.assertEquals((String)"Vampire", (String)job.getName());
        AssertJUnit.assertEquals((Object)this.fromConfig(), (Object)job.getFromJobConfig());
        AssertJUnit.assertEquals((Object)this.toConfig(), (Object)job.getToJobConfig());
        AssertJUnit.assertEquals((Object)this.driverConfig(), (Object)job.getDriverConfig());
        MJob copy = new MJob(job);
        AssertJUnit.assertEquals((long)123L, (long)copy.getFromConnectorId());
        AssertJUnit.assertEquals((long)456L, (long)copy.getToConnectorId());
        AssertJUnit.assertEquals((String)"Buffy", (String)copy.getCreationUser());
        AssertJUnit.assertEquals((String)"Vampire", (String)copy.getName());
        AssertJUnit.assertEquals((Object)this.fromConfig(), (Object)copy.getFromJobConfig());
        AssertJUnit.assertEquals((Object)this.toConfig(), (Object)copy.getToJobConfig());
        AssertJUnit.assertEquals((Object)this.driverConfig(), (Object)copy.getDriverConfig());
        MJob upgradeCopy = new MJob(job, this.fromConfig(), this.toConfig(), this.driverConfig());
        AssertJUnit.assertEquals((long)123L, (long)upgradeCopy.getFromConnectorId());
        AssertJUnit.assertEquals((long)456L, (long)upgradeCopy.getToConnectorId());
        AssertJUnit.assertEquals((String)"Buffy", (String)upgradeCopy.getCreationUser());
        AssertJUnit.assertEquals((String)"Vampire", (String)upgradeCopy.getName());
        AssertJUnit.assertEquals((Object)this.fromConfig(), (Object)upgradeCopy.getFromJobConfig());
        AssertJUnit.assertEquals((Object)this.toConfig(), (Object)upgradeCopy.getToJobConfig());
        AssertJUnit.assertEquals((Object)this.driverConfig(), (Object)upgradeCopy.getDriverConfig());
    }

    @Test
    public void testClone() {
        MJob job = this.job();
        MJob withoutJobValue = job.clone(false);
        AssertJUnit.assertEquals((Object)job, (Object)withoutJobValue);
        AssertJUnit.assertEquals((long)-1L, (long)withoutJobValue.getPersistenceId());
        Assert.assertNull((Object)withoutJobValue.getName());
        Assert.assertNull((Object)withoutJobValue.getCreationUser());
        AssertJUnit.assertEquals((Object)this.fromConfig(), (Object)withoutJobValue.getFromJobConfig());
        AssertJUnit.assertEquals((Object)this.toConfig(), (Object)withoutJobValue.getToJobConfig());
        AssertJUnit.assertEquals((Object)this.driverConfig(), (Object)withoutJobValue.getDriverConfig());
        Assert.assertNull((Object)withoutJobValue.getFromJobConfig().getConfig("CONFIGFROMNAME").getInput("INTEGER-INPUT").getValue());
        Assert.assertNull((Object)withoutJobValue.getFromJobConfig().getConfig("CONFIGFROMNAME").getInput("STRING-INPUT").getValue());
        MJob withJobValue = job.clone(true);
        AssertJUnit.assertEquals((Object)job, (Object)withJobValue);
        AssertJUnit.assertEquals((long)job.getPersistenceId(), (long)withJobValue.getPersistenceId());
        AssertJUnit.assertEquals((String)job.getName(), (String)withJobValue.getName());
        AssertJUnit.assertEquals((String)job.getCreationUser(), (String)withJobValue.getCreationUser());
        AssertJUnit.assertEquals((Object)this.fromConfig(), (Object)withJobValue.getFromJobConfig());
        AssertJUnit.assertEquals((Object)this.toConfig(), (Object)withJobValue.getToJobConfig());
        AssertJUnit.assertEquals((Object)this.driverConfig(), (Object)withJobValue.getDriverConfig());
        AssertJUnit.assertEquals((Object)100, (Object)withJobValue.getFromJobConfig().getConfig("CONFIGFROMNAME").getInput("INTEGER-INPUT").getValue());
        AssertJUnit.assertEquals((Object)"TEST-VALUE", (Object)withJobValue.getFromJobConfig().getConfig("CONFIGFROMNAME").getInput("STRING-INPUT").getValue());
    }

    private MJob job() {
        MJob job = new MJob(123L, 456L, 1L, 2L, this.fromConfig(), this.toConfig(), this.driverConfig());
        job.setName("Vampire");
        job.setCreationUser("Buffy");
        return job;
    }

    private MFromConfig fromConfig() {
        ArrayList<MConfig> configs = new ArrayList<MConfig>();
        MIntegerInput input = new MIntegerInput("INTEGER-INPUT", false, InputEditable.ANY, "");
        input.setValue((Object)100);
        MLongInput lInput = new MLongInput("LONG-INPUT", false, InputEditable.ANY, "");
        lInput.setValue((Object)100L);
        MStringInput strInput = new MStringInput("STRING-INPUT", false, InputEditable.ANY, "", 20);
        strInput.setValue((Object)"TEST-VALUE");
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(input);
        list.add(strInput);
        MConfig config = new MConfig("CONFIGFROMNAME", list);
        configs.add(config);
        return new MFromConfig(configs);
    }

    private MToConfig toConfig() {
        ArrayList<MConfig> configs = new ArrayList<MConfig>();
        MMapInput input = new MMapInput("MAP-INPUT", false, InputEditable.ANY, "");
        ArrayList<MMapInput> list = new ArrayList<MMapInput>();
        list.add(input);
        MConfig config = new MConfig("CONFIGTONAME", list);
        configs.add(config);
        return new MToConfig(configs);
    }

    private MDriverConfig driverConfig() {
        ArrayList<MConfig> configs = new ArrayList<MConfig>();
        MMapInput input = new MMapInput("MAP-INPUT", false, InputEditable.ANY, "");
        ArrayList<MMapInput> list = new ArrayList<MMapInput>();
        list.add(input);
        MConfig config = new MConfig("CONFIGDRIVERNAME", list);
        configs.add(config);
        return new MDriverConfig(configs);
    }
}

