/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.model;

import org.apache.sqoop.model.InputEditable;
import org.apache.sqoop.model.MInputType;
import org.apache.sqoop.model.MIntegerInput;
import org.apache.sqoop.model.MStringInput;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

public class TestMIntegerInput {
    @Test
    public void testInitialization() {
        MIntegerInput input = new MIntegerInput("sqoopsqoop", false, InputEditable.ANY, "");
        AssertJUnit.assertEquals((String)"sqoopsqoop", (String)input.getName());
        AssertJUnit.assertEquals((Object)MInputType.INTEGER, (Object)input.getType());
    }

    @Test
    public void testEquals() {
        MIntegerInput input1 = new MIntegerInput("sqoopsqoop", false, InputEditable.ANY, "");
        MIntegerInput input2 = new MIntegerInput("sqoopsqoop", false, InputEditable.ANY, "");
        Assert.assertTrue((boolean)input1.equals((Object)input2));
        MIntegerInput input3 = new MIntegerInput("sqoopsqoop", false, InputEditable.ANY, "");
        MIntegerInput input4 = new MIntegerInput("sqoopsqoop1", false, InputEditable.ANY, "");
        Assert.assertFalse((boolean)input3.equals((Object)input4));
    }

    @Test
    public void testValue() {
        MIntegerInput input1 = new MIntegerInput("sqoopsqoop", false, InputEditable.ANY, "");
        input1.setValue((Object)99);
        AssertJUnit.assertEquals((Object)new Integer(99), (Object)input1.getValue());
        input1.setEmpty();
        Assert.assertNull((Object)input1.getValue());
    }

    @Test
    public void testUrlSafe() {
        MIntegerInput input1 = new MIntegerInput("sqoopsqoop", false, InputEditable.ANY, "");
        input1.setValue((Object)1001);
        String tmp = input1.getUrlSafeValueString();
        input1.restoreFromUrlSafeValueString(tmp);
        AssertJUnit.assertEquals((Object)new Integer(1001), (Object)input1.getValue());
    }

    @Test
    public void testNamedElement() {
        MStringInput input1 = new MStringInput("sqoopsqoop", true, InputEditable.CONNECTOR_ONLY, "", 5);
        AssertJUnit.assertEquals((String)"sqoopsqoop.label", (String)input1.getLabelKey());
        AssertJUnit.assertEquals((String)"sqoopsqoop.help", (String)input1.getHelpKey());
    }

    @Test
    public void testSensitivity() {
        MIntegerInput input1 = new MIntegerInput("NAME", false, InputEditable.USER_ONLY, "");
        MIntegerInput input2 = new MIntegerInput("NAME", true, InputEditable.CONNECTOR_ONLY, "");
        Assert.assertFalse((boolean)input1.isSensitive());
        Assert.assertTrue((boolean)input2.isSensitive());
    }
}

