/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.sqoop.common.Direction;
import org.apache.sqoop.model.InputEditable;
import org.apache.sqoop.model.MConfig;
import org.apache.sqoop.model.MConnector;
import org.apache.sqoop.model.MFromConfig;
import org.apache.sqoop.model.MInput;
import org.apache.sqoop.model.MIntegerInput;
import org.apache.sqoop.model.MLinkConfig;
import org.apache.sqoop.model.MStringInput;
import org.apache.sqoop.model.MToConfig;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

public class TestMConnector {
    private MConnector createConnector(List<Direction> supportedDirections) {
        ArrayList<MConfig> configs = new ArrayList<MConfig>();
        MIntegerInput inputs = new MIntegerInput("INTEGER-INPUT", false, InputEditable.ANY, "");
        inputs.setValue((Object)100);
        MStringInput strInput = new MStringInput("STRING-INPUT", false, InputEditable.ANY, "", 20);
        strInput.setValue((Object)"TEST-VALUE");
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(inputs);
        list.add(strInput);
        MConfig config = new MConfig("CONFIGNAME", list);
        configs.add(config);
        MLinkConfig linkConfig = new MLinkConfig(configs);
        MFromConfig fromConfig = null;
        MToConfig toConfig = null;
        if (supportedDirections.contains(Direction.FROM)) {
            fromConfig = new MFromConfig(configs);
        }
        if (supportedDirections.contains(Direction.TO)) {
            toConfig = new MToConfig(configs);
        }
        return new MConnector("NAME", "CLASSNAME", "1.0", linkConfig, fromConfig, toConfig);
    }

    @Test
    public void testInitialization() {
        ArrayList fromJobConfig = new ArrayList();
        ArrayList toJobConfig = new ArrayList();
        MLinkConfig linkConfig = new MLinkConfig(fromJobConfig);
        MFromConfig fromConfig1 = new MFromConfig(fromJobConfig);
        MToConfig toConfig1 = new MToConfig(toJobConfig);
        MConnector connector1 = new MConnector("NAME", "CLASSNAME", "1.0", linkConfig, fromConfig1, toConfig1);
        AssertJUnit.assertEquals((String)"NAME", (String)connector1.getUniqueName());
        AssertJUnit.assertEquals((String)"CLASSNAME", (String)connector1.getClassName());
        AssertJUnit.assertEquals((String)"1.0", (String)connector1.getVersion());
        MConnector connector2 = new MConnector("NAME", "CLASSNAME", "1.0", linkConfig, fromConfig1, toConfig1);
        AssertJUnit.assertEquals((Object)connector2, (Object)connector1);
        MConnector connector3 = new MConnector("NAME1", "CLASSNAME", "2.0", linkConfig, fromConfig1, toConfig1);
        Assert.assertFalse((boolean)connector1.equals((Object)connector3));
        try {
            connector1 = new MConnector(null, "CLASSNAME", "1.0", linkConfig, fromConfig1, toConfig1);
        }
        catch (NullPointerException e) {
            Assert.assertTrue((boolean)true);
        }
        try {
            connector1 = new MConnector("NAME", null, "1.0", linkConfig, fromConfig1, toConfig1);
        }
        catch (NullPointerException e) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testClone() {
        MConnector connector = this.createConnector(Arrays.asList(Direction.FROM, Direction.TO));
        AssertJUnit.assertEquals((String)"NAME", (String)connector.getUniqueName());
        AssertJUnit.assertEquals((String)"CLASSNAME", (String)connector.getClassName());
        AssertJUnit.assertEquals((String)"1.0", (String)connector.getVersion());
        MConnector cloneConnector1 = connector.clone(true);
        AssertJUnit.assertEquals((String)"NAME", (String)cloneConnector1.getUniqueName());
        AssertJUnit.assertEquals((String)"CLASSNAME", (String)cloneConnector1.getClassName());
        AssertJUnit.assertEquals((String)"1.0", (String)cloneConnector1.getVersion());
        MConfig clonedLinkConfig = (MConfig)cloneConnector1.getLinkConfig().getConfigs().get(0);
        Assert.assertNull((Object)((MInput)clonedLinkConfig.getInputs().get(0)).getValue());
        Assert.assertNull((Object)((MInput)clonedLinkConfig.getInputs().get(1)).getValue());
        MConfig clonedFromConfig = (MConfig)cloneConnector1.getFromConfig().getConfigs().get(0);
        Assert.assertNull((Object)((MInput)clonedFromConfig.getInputs().get(0)).getValue());
        Assert.assertNull((Object)((MInput)clonedFromConfig.getInputs().get(1)).getValue());
        MConfig clonedToConfig = (MConfig)cloneConnector1.getToConfig().getConfigs().get(0);
        Assert.assertNull((Object)((MInput)clonedToConfig.getInputs().get(0)).getValue());
        Assert.assertNull((Object)((MInput)clonedToConfig.getInputs().get(1)).getValue());
        MConnector clonedConnector2 = connector.clone(false);
        clonedLinkConfig = (MConfig)clonedConnector2.getLinkConfig().getConfigs().get(0);
        Assert.assertNull((Object)((MInput)clonedLinkConfig.getInputs().get(0)).getValue());
        Assert.assertNull((Object)((MInput)clonedLinkConfig.getInputs().get(1)).getValue());
        clonedFromConfig = (MConfig)clonedConnector2.getFromConfig().getConfigs().get(0);
        Assert.assertNull((Object)((MInput)clonedFromConfig.getInputs().get(0)).getValue());
        Assert.assertNull((Object)((MInput)clonedFromConfig.getInputs().get(1)).getValue());
        clonedToConfig = (MConfig)clonedConnector2.getToConfig().getConfigs().get(0);
        Assert.assertNull((Object)((MInput)clonedToConfig.getInputs().get(0)).getValue());
        Assert.assertNull((Object)((MInput)clonedToConfig.getInputs().get(1)).getValue());
    }

    @Test
    public void testFromDirection() {
        MConnector connector = this.createConnector(Arrays.asList(Direction.FROM));
        MConnector clone = connector.clone(true);
        Assert.assertNotNull((Object)clone.getFromConfig());
        Assert.assertNull((Object)clone.getToConfig());
        AssertJUnit.assertEquals((Object)connector, (Object)clone);
        AssertJUnit.assertEquals((String)connector.toString(), (String)clone.toString());
        Assert.assertNotEquals((Object)connector.hashCode(), (Object)clone.hashCode());
    }

    @Test
    public void testToDirection() {
        MConnector connector = this.createConnector(Arrays.asList(Direction.TO));
        MConnector clone = connector.clone(true);
        Assert.assertNull((Object)clone.getFromConfig());
        Assert.assertNotNull((Object)clone.getToConfig());
        AssertJUnit.assertEquals((Object)connector, (Object)clone);
        AssertJUnit.assertEquals((String)connector.toString(), (String)clone.toString());
        Assert.assertNotEquals((Object)connector.hashCode(), (Object)clone.hashCode());
    }

    @Test
    public void testNoDirection() {
        MConnector connector = this.createConnector(Arrays.asList(new Direction[0]));
        MConnector clone = connector.clone(true);
        Assert.assertNull((Object)clone.getFromConfig());
        Assert.assertNull((Object)clone.getToConfig());
        AssertJUnit.assertEquals((Object)connector, (Object)clone);
        AssertJUnit.assertEquals((String)connector.toString(), (String)clone.toString());
        Assert.assertNotEquals((Object)connector.hashCode(), (Object)clone.hashCode());
    }

    @Test
    public void testBothDirections() {
        MConnector connector = this.createConnector(Arrays.asList(Direction.FROM, Direction.TO));
        MConnector clone = connector.clone(true);
        Assert.assertNotNull((Object)clone.getFromConfig());
        Assert.assertNotNull((Object)clone.getToConfig());
        AssertJUnit.assertEquals((Object)connector, (Object)clone);
        AssertJUnit.assertEquals((String)connector.toString(), (String)clone.toString());
        Assert.assertNotEquals((Object)connector.hashCode(), (Object)clone.hashCode());
    }

    @Test
    public void testGetSupportedDirections() {
        MConnector connector = this.createConnector(Arrays.asList(Direction.FROM, Direction.TO));
        Assert.assertTrue((boolean)connector.getSupportedDirections().isDirectionSupported(Direction.FROM));
        Assert.assertTrue((boolean)connector.getSupportedDirections().isDirectionSupported(Direction.TO));
        connector = this.createConnector(Arrays.asList(Direction.FROM));
        Assert.assertTrue((boolean)connector.getSupportedDirections().isDirectionSupported(Direction.FROM));
        Assert.assertFalse((boolean)connector.getSupportedDirections().isDirectionSupported(Direction.TO));
        connector = this.createConnector(Arrays.asList(Direction.TO));
        Assert.assertFalse((boolean)connector.getSupportedDirections().isDirectionSupported(Direction.FROM));
        Assert.assertTrue((boolean)connector.getSupportedDirections().isDirectionSupported(Direction.TO));
        connector = this.createConnector(Arrays.asList(new Direction[0]));
        Assert.assertFalse((boolean)connector.getSupportedDirections().isDirectionSupported(Direction.FROM));
        Assert.assertFalse((boolean)connector.getSupportedDirections().isDirectionSupported(Direction.TO));
    }
}

