/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.model;

import java.util.ArrayList;
import org.apache.sqoop.model.InputEditable;
import org.apache.sqoop.model.MConfig;
import org.apache.sqoop.model.MEnumInput;
import org.apache.sqoop.model.MIntegerInput;
import org.apache.sqoop.model.MLongInput;
import org.apache.sqoop.model.MMapInput;
import org.apache.sqoop.model.MStringInput;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestMConfig {
    @Test
    public void testInitialization() {
        MStringInput input1 = new MStringInput("sqoopsqoop1", true, InputEditable.ANY, "", 5);
        MStringInput input2 = new MStringInput("sqoopsqoop2", true, InputEditable.ANY, "", 5);
        ArrayList<MStringInput> list = new ArrayList<MStringInput>();
        list.add(input1);
        list.add(input2);
        MConfig mConfig = new MConfig("config", list);
        Assert.assertEquals((String)"config", (String)mConfig.getName());
        Assert.assertEquals((int)2, (int)mConfig.getInputs().size());
    }

    @Test
    public void testEquals() {
        MIntegerInput input1 = new MIntegerInput("sqoopsqoop1", false, InputEditable.ANY, "");
        MIntegerInput input2 = new MIntegerInput("sqoopsqoop2", false, InputEditable.ANY, "");
        ArrayList<MIntegerInput> list1 = new ArrayList<MIntegerInput>();
        list1.add(input1);
        list1.add(input2);
        MConfig mConfig1 = new MConfig("config", list1);
        MIntegerInput input3 = new MIntegerInput("sqoopsqoop1", false, InputEditable.ANY, "");
        MIntegerInput input4 = new MIntegerInput("sqoopsqoop2", false, InputEditable.ANY, "");
        ArrayList<MIntegerInput> list2 = new ArrayList<MIntegerInput>();
        list2.add(input3);
        list2.add(input4);
        MConfig mConfig2 = new MConfig("config", list2);
        Assert.assertEquals((Object)mConfig2, (Object)mConfig1);
    }

    @Test
    public void testGetInputs() {
        MIntegerInput intInput = new MIntegerInput("Config.A", false, InputEditable.ANY, "");
        MLongInput longInput = new MLongInput("Config.A1", false, InputEditable.ANY, "");
        MMapInput mapInput = new MMapInput("Config.B", false, InputEditable.ANY, "");
        MStringInput stringInput = new MStringInput("Config.C", false, InputEditable.ANY, "", 3);
        MEnumInput enumInput = new MEnumInput("Config.D", false, InputEditable.ANY, "", new String[]{"I", "V"});
        ArrayList<Object> inputs = new ArrayList<Object>();
        inputs.add(intInput);
        inputs.add(longInput);
        inputs.add(mapInput);
        inputs.add(stringInput);
        inputs.add(enumInput);
        MConfig config = new MConfig("Config", inputs);
        Assert.assertEquals((Object)intInput, (Object)config.getIntegerInput("Config.A"));
        Assert.assertEquals((Object)longInput, (Object)config.getLongInput("Config.A1"));
        Assert.assertEquals((Object)mapInput, (Object)config.getMapInput("Config.B"));
        Assert.assertEquals((Object)stringInput, (Object)config.getStringInput("Config.C"));
        Assert.assertEquals((Object)enumInput, (Object)config.getEnumInput("Config.D"));
    }
}

