/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.model;

import java.util.ArrayList;
import java.util.Date;
import org.apache.sqoop.model.InputEditable;
import org.apache.sqoop.model.MConfig;
import org.apache.sqoop.model.MIntegerInput;
import org.apache.sqoop.model.MLink;
import org.apache.sqoop.model.MLinkConfig;
import org.apache.sqoop.model.MLongInput;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

public class TestMAccountableEntity {
    @Test
    public void testInitialization() {
        ArrayList<MConfig> configs = new ArrayList<MConfig>();
        MIntegerInput intInput = new MIntegerInput("INTEGER-INPUT", false, InputEditable.ANY, "");
        MLongInput longInput = new MLongInput("LONG-INPUT", false, InputEditable.ANY, "");
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(intInput);
        list.add(longInput);
        MConfig config = new MConfig("CONFIGNAME", list);
        configs.add(config);
        MLink link = new MLink(123L, new MLinkConfig(configs));
        AssertJUnit.assertEquals((Object)link.getCreationDate(), (Object)link.getLastUpdateDate());
        Date testCreationDate = new Date();
        Date testLastUpdateDate = new Date();
        link.setCreationUser("admin");
        link.setCreationDate(testCreationDate);
        link.setLastUpdateUser("user");
        link.setLastUpdateDate(testLastUpdateDate);
        link.setEnabled(false);
        AssertJUnit.assertEquals((Object)testCreationDate, (Object)link.getCreationDate());
        AssertJUnit.assertEquals((String)"admin", (String)link.getCreationUser());
        AssertJUnit.assertEquals((Object)testLastUpdateDate, (Object)link.getLastUpdateDate());
        AssertJUnit.assertEquals((boolean)false, (boolean)link.getEnabled());
        AssertJUnit.assertEquals((String)"user", (String)link.getLastUpdateUser());
        AssertJUnit.assertEquals((int)1, (int)link.getConnectorLinkConfig().getConfigs().size());
        AssertJUnit.assertEquals((int)2, (int)((MConfig)link.getConnectorLinkConfig().getConfigs().get(0)).getInputs().size());
    }
}

