/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.model;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.model.Config;
import org.apache.sqoop.model.ConfigClass;
import org.apache.sqoop.model.ConfigUtils;
import org.apache.sqoop.model.ConfigurationClass;
import org.apache.sqoop.model.Input;
import org.apache.sqoop.model.InputEditable;
import org.apache.sqoop.model.MConfig;
import org.apache.sqoop.model.MEnumInput;
import org.apache.sqoop.model.MInput;
import org.apache.sqoop.model.MLongInput;
import org.apache.sqoop.model.MMapInput;
import org.apache.sqoop.model.MStringInput;
import org.apache.sqoop.model.ModelError;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

public class TestConfigUtils {
    @Test
    public void testConfigs() {
        TestConfiguration config = new TestConfiguration();
        config.aConfig.a1 = "value";
        List configsByInstance = ConfigUtils.toConfigs((Object)config);
        AssertJUnit.assertEquals(this.getConfigs(), (Object)configsByInstance);
        AssertJUnit.assertEquals((Object)"value", (Object)((MInput)((MConfig)configsByInstance.get(0)).getInputs().get(0)).getValue());
        List configsByClass = ConfigUtils.toConfigs(TestConfiguration.class);
        AssertJUnit.assertEquals(this.getConfigs(), (Object)configsByClass);
        List configsByBoth = ConfigUtils.toConfigs(TestConfiguration.class, (Object)config);
        AssertJUnit.assertEquals(this.getConfigs(), (Object)configsByBoth);
        AssertJUnit.assertEquals((Object)"value", (Object)((MInput)((MConfig)configsByBoth.get(0)).getInputs().get(0)).getValue());
    }

    @Test(expectedExceptions={SqoopException.class})
    public void testBadConfigInputsWithNonExisitingOverride() {
        TestBadConfiguration config = new TestBadConfiguration();
        config.aBadConfig.a1 = "value";
        ConfigUtils.toConfigs((Object)config);
    }

    @Test(expectedExceptions={SqoopException.class})
    public void testBadConfigInputsWithBadOverride() {
        TestBadConfiguration1 config = new TestBadConfiguration1();
        config.aBadConfig1.a1 = "value";
        ConfigUtils.toConfigs((Object)config);
    }

    @Test(expectedExceptions={SqoopException.class})
    public void testBadConfigInputsWithSelfOverride() {
        TestBadConfiguration2 config = new TestBadConfiguration2();
        config.aBadConfig2.a1 = "value";
        ConfigUtils.toConfigs((Object)config);
    }

    @Test
    public void testConfigsMissingAnnotation() {
        try {
            ConfigUtils.toConfigs(ConfigWithoutAnnotation.class);
        }
        catch (SqoopException ex) {
            AssertJUnit.assertEquals((Object)ModelError.MODEL_003, (Object)ex.getErrorCode());
            return;
        }
        Assert.fail((String)"Correct exception wasn't thrown");
    }

    @Test
    public void testNonUniqueConfigNameAttributes() {
        try {
            ConfigUtils.toConfigs(ConfigurationWithNonUniqueConfigNameAttribute.class);
        }
        catch (SqoopException ex) {
            AssertJUnit.assertEquals((Object)ModelError.MODEL_012, (Object)ex.getErrorCode());
            return;
        }
        Assert.fail((String)"Correct exception wasn't thrown");
    }

    @Test
    public void testInvalidConfigNameAttribute() {
        try {
            ConfigUtils.toConfigs(ConfigurationWithInvalidConfigNameAttribute.class);
        }
        catch (SqoopException ex) {
            AssertJUnit.assertEquals((Object)ModelError.MODEL_013, (Object)ex.getErrorCode());
            return;
        }
        Assert.fail((String)"Correct exception wasn't thrown");
    }

    @Test
    public void testInvalidConfigNameAttributeLength() {
        try {
            ConfigUtils.toConfigs(ConfigurationWithInvalidConfigNameAttributeLength.class);
        }
        catch (SqoopException ex) {
            AssertJUnit.assertEquals((Object)ModelError.MODEL_014, (Object)ex.getErrorCode());
            return;
        }
        Assert.fail((String)"Correct exception wasn't thrown");
    }

    @Test
    public void testFailureOnPrimitiveType() {
        PrimitiveConfig config = new PrimitiveConfig();
        try {
            ConfigUtils.toConfigs((Object)config);
            Assert.fail((String)"We were expecting exception for unsupported type.");
        }
        catch (SqoopException ex) {
            AssertJUnit.assertEquals((Object)ModelError.MODEL_007, (Object)ex.getErrorCode());
        }
    }

    @Test
    public void testFillValues() {
        List<MConfig> configs = this.getConfigs();
        ((MStringInput)configs.get(0).getInputs().get(0)).setValue((Object)"value");
        TestConfiguration config = new TestConfiguration();
        ConfigUtils.fromConfigs(configs, (Object)config);
        AssertJUnit.assertEquals((String)"value", (String)config.aConfig.a1);
    }

    @Test
    public void testFromConfigWithClass() {
        List<MConfig> configs = this.getConfigs();
        ((MStringInput)configs.get(0).getInputs().get(0)).setValue((Object)"value");
        TestConfiguration config = (TestConfiguration)ConfigUtils.fromConfigs(configs, TestConfiguration.class);
        AssertJUnit.assertEquals((String)"value", (String)config.aConfig.a1);
    }

    @Test
    public void testFillValuesObjectReuse() {
        List<MConfig> configs = this.getConfigs();
        ((MStringInput)configs.get(0).getInputs().get(0)).setValue((Object)"value");
        TestConfiguration config = new TestConfiguration();
        config.aConfig.a2 = "x";
        config.bConfig.b1 = "y";
        ConfigUtils.fromConfigs(configs, (Object)config);
        AssertJUnit.assertEquals((String)"value", (String)config.aConfig.a1);
        AssertJUnit.assertNull((Object)config.aConfig.a2);
        AssertJUnit.assertNull((Object)config.bConfig.b2);
        AssertJUnit.assertNull((Object)config.bConfig.b2);
    }

    @Test
    public void testJson() {
        TestConfiguration config = new TestConfiguration();
        config.aConfig.a1 = "A";
        config.bConfig.b2 = "B";
        config.cConfig.longValue = 4L;
        config.cConfig.map.put("C", "D");
        config.cConfig.enumeration = Enumeration.X;
        String json = ConfigUtils.toJson((Object)config);
        TestConfiguration targetConfig = new TestConfiguration();
        targetConfig.aConfig.a2 = "X";
        targetConfig.bConfig.b1 = "Y";
        targetConfig.cConfig = null;
        ConfigUtils.fillValues((String)json, (Object)targetConfig);
        AssertJUnit.assertEquals((String)"A", (String)targetConfig.aConfig.a1);
        AssertJUnit.assertNull((Object)targetConfig.aConfig.a2);
        AssertJUnit.assertNull((Object)targetConfig.bConfig.b1);
        AssertJUnit.assertEquals((String)"B", (String)targetConfig.bConfig.b2);
        AssertJUnit.assertEquals((Object)4L, (Object)targetConfig.cConfig.longValue);
        AssertJUnit.assertEquals((int)1, (int)targetConfig.cConfig.map.size());
        AssertJUnit.assertTrue((boolean)targetConfig.cConfig.map.containsKey("C"));
        AssertJUnit.assertEquals((String)"D", (String)targetConfig.cConfig.map.get("C"));
        AssertJUnit.assertEquals((Object)((Object)Enumeration.X), (Object)((Object)targetConfig.cConfig.enumeration));
    }

    protected List<MConfig> getConfigs() {
        LinkedList<MConfig> ret = new LinkedList<MConfig>();
        LinkedList<Object> inputs = new LinkedList<Object>();
        inputs.add(new MStringInput("aConfig.a1", false, InputEditable.ANY, "", 30));
        inputs.add(new MStringInput("aConfig.a2", true, InputEditable.ANY, "", -1));
        ret.add(new MConfig("aConfig", inputs));
        inputs = new LinkedList();
        inputs.add(new MStringInput("bConfig.b1", false, InputEditable.ANY, "", 2));
        inputs.add(new MStringInput("bConfig.b2", false, InputEditable.ANY, "", 3));
        ret.add(new MConfig("bConfig", inputs));
        inputs = new LinkedList();
        inputs.add(new MLongInput("cConfig.longValue", false, InputEditable.ANY, ""));
        inputs.add(new MMapInput("cConfig.map", false, InputEditable.ANY, ""));
        inputs.add(new MEnumInput("cConfig.enumeration", false, InputEditable.ANY, "", new String[]{"X", "Y"}));
        ret.add(new MConfig("cConfig", inputs));
        return ret;
    }

    protected List<MConfig> getBadConfigWithSelfOverrideInputs() {
        LinkedList<MConfig> ret = new LinkedList<MConfig>();
        LinkedList<MStringInput> inputs = new LinkedList<MStringInput>();
        inputs.add(new MStringInput("aConfig.a1", false, InputEditable.ANY, "aConfig.a1", 30));
        inputs.add(new MStringInput("aConfig.a2", true, InputEditable.ANY, "", -1));
        ret.add(new MConfig("aConfig", inputs));
        return ret;
    }

    protected List<MConfig> getBadConfigWithNonExistingOverrideInputs() {
        LinkedList<MConfig> ret = new LinkedList<MConfig>();
        LinkedList<MStringInput> inputs = new LinkedList<MStringInput>();
        inputs.add(new MStringInput("aConfig.a1", false, InputEditable.ANY, "aConfig.a3", 30));
        inputs.add(new MStringInput("aConfig.a2", true, InputEditable.ANY, "", -1));
        ret.add(new MConfig("aConfig", inputs));
        return ret;
    }

    protected List<MConfig> getBadConfigWithUserEditableOverrideInputs() {
        LinkedList<MConfig> ret = new LinkedList<MConfig>();
        LinkedList<MStringInput> inputs = new LinkedList<MStringInput>();
        inputs.add(new MStringInput("aConfig.a1", false, InputEditable.ANY, "aConfig.a2", 30));
        inputs.add(new MStringInput("aConfig.a2", true, InputEditable.USER_ONLY, "", -1));
        ret.add(new MConfig("aConfig", inputs));
        return ret;
    }

    static enum Enumeration {
        X,
        Y;

    }

    public static class ConfigWithoutAnnotation {
    }

    @ConfigClass
    public static class DConfig {
        @Input
        int value;
    }

    @ConfigClass
    public static class InvalidConfig {
    }

    @ConfigClass
    public static class CConfig {
        @Input
        Long longValue;
        @Input
        Map<String, String> map = new HashMap<String, String>();
        @Input
        Enumeration enumeration;
    }

    @ConfigClass
    public static class BConfig {
        @Input(size=2)
        String b1;
        @Input(size=3)
        String b2;
    }

    @ConfigClass
    public static class ABadConfig2 {
        @Input(size=30, editable=InputEditable.USER_ONLY, overrides="a1")
        String a1;
        @Input(sensitive=true, editable=InputEditable.USER_ONLY, overrides="a2")
        String a2;
    }

    @ConfigClass
    public static class ABadConfig1 {
        @Input(size=30, editable=InputEditable.USER_ONLY, overrides="a2")
        String a1;
        @Input(sensitive=true, editable=InputEditable.USER_ONLY, overrides="a1")
        String a2;
    }

    @ConfigClass
    public static class ABadConfig {
        @Input(size=30, editable=InputEditable.USER_ONLY, overrides="a5")
        String a1;
        @Input(sensitive=true)
        String a2;
    }

    @ConfigClass
    public static class AConfig {
        @Input(size=30)
        String a1;
        @Input(sensitive=true)
        String a2;
    }

    @ConfigurationClass
    public static class PrimitiveConfig {
        @Config
        DConfig dConfig;
    }

    @ConfigurationClass
    public static class TestConfiguration {
        @Config
        AConfig aConfig = new AConfig();
        @Config
        BConfig bConfig = new BConfig();
        @Config
        CConfig cConfig = new CConfig();
    }

    @ConfigurationClass
    public static class TestBadConfiguration2 {
        @Config
        ABadConfig2 aBadConfig2 = new ABadConfig2();
    }

    @ConfigurationClass
    public static class TestBadConfiguration1 {
        @Config
        ABadConfig1 aBadConfig1 = new ABadConfig1();
    }

    @ConfigurationClass
    public static class TestBadConfiguration {
        @Config
        ABadConfig aBadConfig = new ABadConfig();
    }

    @ConfigurationClass
    public static class ConfigurationWithInvalidConfigNameAttributeLength {
        @Config(name="longest_config_more_than_30_characers")
        InvalidConfig invalidLengthConfig = new InvalidConfig();
    }

    @ConfigurationClass
    public static class ConfigurationWithInvalidConfigNameAttribute {
        @Config(name="#_config")
        InvalidConfig invalidConfig = new InvalidConfig();
    }

    @ConfigurationClass
    public static class ConfigurationWithNonUniqueConfigNameAttribute {
        @Config(name="sameName")
        InvalidConfig aConfig = new InvalidConfig();
        @Config(name="sameName")
        InvalidConfig bConfig = new InvalidConfig();
    }
}

