/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.json.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.json.JSONUtils;
import org.apache.sqoop.json.util.SchemaSerialization;
import org.apache.sqoop.schema.ByteArraySchema;
import org.apache.sqoop.schema.NullSchema;
import org.apache.sqoop.schema.Schema;
import org.apache.sqoop.schema.type.AbstractPrimitiveType;
import org.apache.sqoop.schema.type.Array;
import org.apache.sqoop.schema.type.Binary;
import org.apache.sqoop.schema.type.Bit;
import org.apache.sqoop.schema.type.Column;
import org.apache.sqoop.schema.type.Date;
import org.apache.sqoop.schema.type.DateTime;
import org.apache.sqoop.schema.type.Decimal;
import org.apache.sqoop.schema.type.Enum;
import org.apache.sqoop.schema.type.FixedPoint;
import org.apache.sqoop.schema.type.FloatingPoint;
import org.apache.sqoop.schema.type.Map;
import org.apache.sqoop.schema.type.Set;
import org.apache.sqoop.schema.type.Text;
import org.apache.sqoop.schema.type.Time;
import org.apache.sqoop.schema.type.Unknown;
import org.json.simple.JSONObject;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

public class TestSchemaSerialization {
    @Test
    public void testSchemaNull() {
        JSONObject extractJson = SchemaSerialization.extractSchema(null);
        JSONObject restoreJson = JSONUtils.parse((String)extractJson.toJSONString());
        AssertJUnit.assertEquals((Object)NullSchema.getInstance(), (Object)SchemaSerialization.restoreSchema((JSONObject)restoreJson));
    }

    @Test
    public void testNullSchemaObject() {
        this.transferAndAssert((Schema)NullSchema.getInstance());
    }

    @Test(expectedExceptions={SqoopException.class})
    public void testEmptySchemaName() {
        Schema schema = new Schema("");
    }

    @Test(expectedExceptions={SqoopException.class})
    public void testNullSchemaName() {
        Schema schema = new Schema(null);
    }

    @Test(expectedExceptions={SqoopException.class})
    public void testSchemaWithNullColumnName() {
        Schema schema = new Schema("test").addColumn((Column)new Text(null));
    }

    @Test(expectedExceptions={SqoopException.class})
    public void testSchemaWithEmptyColumnName() {
        Schema schema = new Schema("test").addColumn((Column)new Text(""));
    }

    @Test
    public void testByteArraySchemaObject() {
        this.transferAndAssert((Schema)ByteArraySchema.getInstance());
    }

    @Test
    public void testArray() {
        Schema array = new Schema("array").addColumn((Column)new Array("a", (Column)new Decimal("a1", Integer.valueOf(5), Integer.valueOf(2))).setSize(Long.valueOf(1L)));
        this.transferAndAssert(array);
    }

    @Test
    public void testBinary() {
        Schema binary = new Schema("b").addColumn((Column)new Binary("A", Long.valueOf(100L)));
        this.transferAndAssert(binary);
    }

    @Test
    public void testBit() {
        Schema bit = new Schema("b").addColumn((Column)new Bit("B"));
        this.transferAndAssert(bit);
    }

    @Test
    public void testDate() {
        Schema date = new Schema("d").addColumn((Column)new Date("d"));
        this.transferAndAssert(date);
    }

    @Test
    public void testDateTime() {
        Schema dateTime = new Schema("dt").addColumn((Column)new DateTime("dt", Boolean.FALSE, Boolean.TRUE));
        this.transferAndAssert(dateTime);
    }

    @Test
    public void testDecimal() {
        Schema decimal = new Schema("d").addColumn((Column)new Decimal("d", Integer.valueOf(5), Integer.valueOf(2)));
        this.transferAndAssert(decimal);
    }

    @Test
    public void testEnum() {
        Schema e = new Schema("e").addColumn((Column)new Enum("e", Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("A", "B")))));
        this.transferAndAssert(e);
    }

    @Test
    public void testFixedPoint() {
        Schema f = new Schema("f").addColumn((Column)new FixedPoint("fp", Long.valueOf(4L), Boolean.FALSE));
        this.transferAndAssert(f);
    }

    @Test
    public void testFloatingPoint() {
        Schema fp = new Schema("fp").addColumn((Column)new FloatingPoint("k", Long.valueOf(4L)));
        this.transferAndAssert(fp);
    }

    @Test
    public void testMap() {
        Schema m = new Schema("m").addColumn((Column)new Map("m", (AbstractPrimitiveType)new Text("m1"), (Column)new Decimal("m2", Integer.valueOf(5), Integer.valueOf(2))));
        this.transferAndAssert(m);
    }

    @Test
    public void testSet() {
        Schema s = new Schema("s").addColumn((Column)new Set("b", (Column)new Binary("b1")));
        this.transferAndAssert(s);
    }

    @Test
    public void testText() {
        Schema t = new Schema("t").addColumn((Column)new Text("x", Long.valueOf(10L)));
        this.transferAndAssert(t);
    }

    @Test
    public void testTime() {
        Schema t = new Schema("t").addColumn((Column)new Time("t", Boolean.FALSE));
        this.transferAndAssert(t);
    }

    @Test
    public void testUnknown() {
        Schema t = new Schema("t").addColumn((Column)new Unknown("u", Long.valueOf(4L)));
        this.transferAndAssert(t);
    }

    @Test
    public void testNullable() {
        Schema nullable = new Schema("n").addColumn((Column)new Text("x", Boolean.FALSE));
        this.transferAndAssert(nullable);
    }

    @Test
    public void testAllTypes() {
        Schema allTypes = new Schema("all-types").addColumn((Column)new Array("a", (Column)new Text("a1"))).addColumn((Column)new Binary("b")).addColumn((Column)new Bit("c")).addColumn((Column)new Date("d")).addColumn((Column)new DateTime("e", Boolean.valueOf(true), Boolean.valueOf(true))).addColumn((Column)new Decimal("f", Integer.valueOf(5), Integer.valueOf(2))).addColumn((Column)new Enum("g", Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("X", "Y"))))).addColumn((Column)new FixedPoint("h", Long.valueOf(2L), Boolean.valueOf(false))).addColumn((Column)new FloatingPoint("i", Long.valueOf(4L))).addColumn((Column)new Map("j", (AbstractPrimitiveType)new Text("j1"), (Column)new Text("j2"))).addColumn((Column)new Set("k", (Column)new Text("k1"))).addColumn((Column)new Text("l")).addColumn((Column)new Time("m", Boolean.valueOf(true))).addColumn((Column)new Unknown("u"));
        this.transferAndAssert(allTypes);
    }

    @Test
    public void testComplex() {
        Schema complex = new Schema("complex").addColumn((Column)new Map("a", (AbstractPrimitiveType)new Text("a1"), (Column)new Set("a2", (Column)new Array("a3", (Column)new Text("a4")))));
        this.transferAndAssert(complex);
    }

    private void transferAndAssert(Schema schema) {
        Schema transferred = this.transfer(schema);
        AssertJUnit.assertEquals((Object)schema, (Object)transferred);
    }

    protected Schema transfer(Schema schema) {
        JSONObject extractJson = SchemaSerialization.extractSchema((Schema)schema);
        String transferredString = extractJson.toJSONString();
        JSONObject restoreJson = JSONUtils.parse((String)transferredString);
        return SchemaSerialization.restoreSchema((JSONObject)restoreJson);
    }
}

