/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.json.util;

import java.util.HashMap;
import java.util.LinkedList;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.json.JSONUtils;
import org.apache.sqoop.json.util.ConfigInputSerialization;
import org.apache.sqoop.model.InputEditable;
import org.apache.sqoop.model.MBooleanInput;
import org.apache.sqoop.model.MConfig;
import org.apache.sqoop.model.MConfigType;
import org.apache.sqoop.model.MEnumInput;
import org.apache.sqoop.model.MIntegerInput;
import org.apache.sqoop.model.MLongInput;
import org.apache.sqoop.model.MMapInput;
import org.apache.sqoop.model.MStringInput;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

public class TestConfigSerialization {
    @Test
    public void testAllDataTypes() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("A", "B");
        MConfig config = this.getConfig();
        config.getStringInput("String").setValue((Object)"A");
        config.getMapInput("Map").setValue(map);
        config.getIntegerInput("Integer").setValue((Object)1);
        config.getBooleanInput("Boolean").setValue((Object)true);
        config.getEnumInput("Enum").setValue("YES");
        JSONObject jsonObject = ConfigInputSerialization.extractConfig((MConfig)config, (MConfigType)MConfigType.JOB, (boolean)false);
        Assert.assertNotNull((Object)jsonObject);
        String serializedJson = jsonObject.toJSONString();
        JSONObject retrievedJson = JSONUtils.parse((String)serializedJson);
        MConfig retrieved = ConfigInputSerialization.restoreConfig((JSONObject)retrievedJson);
        AssertJUnit.assertEquals((String)"A", (String)((String)retrieved.getStringInput("String").getValue()));
        AssertJUnit.assertEquals(map, (Object)retrieved.getMapInput("Map").getValue());
        AssertJUnit.assertEquals((int)1, (int)((Integer)retrieved.getIntegerInput("Integer").getValue()));
        AssertJUnit.assertEquals((boolean)true, (boolean)((Boolean)retrieved.getBooleanInput("Boolean").getValue()));
        AssertJUnit.assertEquals((String)"YES", (String)((String)retrieved.getEnumInput("Enum").getValue()));
    }

    @Test
    public void testMapDataType() {
        MConfig config = this.getMapConfig();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("A", "B");
        config.getMapInput("Map").setValue(map);
        JSONObject jsonObject = ConfigInputSerialization.extractConfig((MConfig)config, (MConfigType)MConfigType.JOB, (boolean)false);
        String serializedJson = jsonObject.toJSONString();
        JSONObject retrievedJson = JSONUtils.parse((String)serializedJson);
        MConfig retrieved = ConfigInputSerialization.restoreConfig((JSONObject)retrievedJson);
        AssertJUnit.assertEquals(map, (Object)retrieved.getMapInput("Map").getValue());
    }

    @Test(expectedExceptions={SqoopException.class})
    public void testMapDataTypeException() {
        MConfig config = this.getMapConfig();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("A", "B");
        config.getMapInput("Map").setValue(map);
        JSONObject jsonObject = ConfigInputSerialization.extractConfig((MConfig)config, (MConfigType)MConfigType.JOB, (boolean)false);
        String serializedJson = jsonObject.toJSONString();
        String badSerializedJson = serializedJson.replace("{\"A\":\"B\"}", "\"nonsensical string\"");
        System.out.println(badSerializedJson);
        JSONObject retrievedJson = JSONUtils.parse((String)badSerializedJson);
        ConfigInputSerialization.restoreConfig((JSONObject)retrievedJson);
    }

    @Test
    public void testInputEditableOptional() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("A", "B");
        MConfig config = this.getConfig();
        config.getStringInput("String").setValue((Object)"A");
        config.getMapInput("Map").setValue(map);
        config.getIntegerInput("Integer").setValue((Object)1);
        config.getBooleanInput("Boolean").setValue((Object)true);
        config.getEnumInput("Enum").setValue("YES");
        JSONObject jsonObject = ConfigInputSerialization.extractConfig((MConfig)config, (MConfigType)MConfigType.JOB, (boolean)false);
        Assert.assertNotNull((Object)jsonObject);
        JSONArray inputs = (JSONArray)jsonObject.get((Object)"inputs");
        for (int i = 0; i < inputs.size(); ++i) {
            JSONObject input = (JSONObject)inputs.get(i);
            if (!input.containsKey((Object)"editable")) continue;
            input.remove((Object)"editable");
        }
        String serializedJson = jsonObject.toJSONString();
        JSONObject retrievedJson = JSONUtils.parse((String)serializedJson);
        inputs = (JSONArray)retrievedJson.get((Object)"inputs");
        for (int i = 0; i < inputs.size(); ++i) {
            JSONObject input = (JSONObject)inputs.get(i);
            Assert.assertFalse((boolean)input.containsKey((Object)"editable"));
        }
        MConfig retrieved = ConfigInputSerialization.restoreConfig((JSONObject)retrievedJson);
        AssertJUnit.assertEquals((String)"A", (String)((String)retrieved.getStringInput("String").getValue()));
        AssertJUnit.assertEquals(map, (Object)retrieved.getMapInput("Map").getValue());
        AssertJUnit.assertEquals((int)1, (int)((Integer)retrieved.getIntegerInput("Integer").getValue()));
        AssertJUnit.assertEquals((boolean)true, (boolean)((Boolean)retrieved.getBooleanInput("Boolean").getValue()));
        AssertJUnit.assertEquals((String)"YES", (String)((String)retrieved.getEnumInput("Enum").getValue()));
    }

    protected MConfig getMapConfig() {
        LinkedList<MMapInput> inputs = new LinkedList<MMapInput>();
        MMapInput input = new MMapInput("Map", false, InputEditable.ANY, "");
        inputs.add(input);
        return new MConfig("c", inputs);
    }

    protected MConfig getConfig() {
        LinkedList<MStringInput> inputs = new LinkedList<MStringInput>();
        MStringInput input = new MStringInput("String", false, InputEditable.ANY, "", 30);
        inputs.add(input);
        input = new MMapInput("Map", false, InputEditable.ANY, "");
        inputs.add(input);
        input = new MIntegerInput("Integer", false, InputEditable.ANY, "");
        inputs.add(input);
        input = new MLongInput("Long", false, InputEditable.ANY, "");
        inputs.add(input);
        input = new MBooleanInput("Boolean", false, InputEditable.ANY, "");
        inputs.add(input);
        input = new MEnumInput("Enum", false, InputEditable.ANY, "", new String[]{"YES", "NO"});
        inputs.add(input);
        return new MConfig("c", inputs);
    }
}

