/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.json.util;

import java.util.Date;
import org.apache.sqoop.json.util.ConfigTestUtil;
import org.apache.sqoop.model.MConnector;
import org.apache.sqoop.model.MFromConfig;
import org.apache.sqoop.model.MJob;
import org.apache.sqoop.model.MLink;
import org.apache.sqoop.model.MToConfig;

public class BeanTestUtil {
    public static MLink createLink(String connectorName, String linkName, Long linkId, Date created, Date updated) {
        MLink link1 = BeanTestUtil.getLink(connectorName);
        link1.setName(linkName);
        link1.setPersistenceId(linkId.longValue());
        link1.setCreationUser("admin");
        link1.setCreationDate(created);
        link1.setLastUpdateUser("user");
        link1.setLastUpdateDate(updated);
        link1.setEnabled(false);
        return link1;
    }

    public static MJob createJob(String connectorName, String jobName, Long jobId, Date created, Date updated) {
        MJob job = BeanTestUtil.getJob(connectorName);
        job.setName(jobName);
        job.setPersistenceId(jobId.longValue());
        job.setCreationDate(created);
        job.setLastUpdateDate(updated);
        job.setEnabled(false);
        return job;
    }

    public static MLink getLink(String connectorName) {
        return new MLink(1L, BeanTestUtil.getConnector(1L, connectorName).getLinkConfig());
    }

    public static MConnector getConnector(Long connectorId, String connectorName) {
        return BeanTestUtil.getConnector(connectorId, connectorName, true, true);
    }

    public static MConnector getConnector(Long id, String name, boolean from, boolean to) {
        MFromConfig fromConfig = null;
        MToConfig toConfig = null;
        if (from) {
            fromConfig = ConfigTestUtil.getFromConfig();
        }
        if (to) {
            toConfig = ConfigTestUtil.getToConfig();
        }
        MConnector connector = new MConnector(name, name + ".class", "1.0-test", ConfigTestUtil.getLinkConfig(), fromConfig, toConfig);
        connector.setPersistenceId(id.longValue());
        return connector;
    }

    public static MJob getJob(String connectorName) {
        return new MJob(1L, 2L, 1L, 2L, BeanTestUtil.getConnector(1L, connectorName).getFromConfig(), BeanTestUtil.getConnector(1L, connectorName).getToConfig(), ConfigTestUtil.getDriverConfig());
    }
}

