/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.json;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.sqoop.json.JSONUtils;
import org.apache.sqoop.json.ValidationResultBean;
import org.apache.sqoop.validation.ConfigValidationResult;
import org.apache.sqoop.validation.Message;
import org.apache.sqoop.validation.Status;
import org.json.simple.JSONObject;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

public class TestValidationResultBean {
    @Test
    public void testEmptyTransfer() {
        ConfigValidationResult[] empty = new ConfigValidationResult[]{};
        ConfigValidationResult[] retrieved = this.transfer(empty);
        AssertJUnit.assertEquals((int)0, (int)retrieved.length);
    }

    @Test
    public void testOneMessage() {
        ConfigValidationResult[] empty = new ConfigValidationResult[]{this.getResultA()};
        ConfigValidationResult[] retrieved = this.transfer(empty);
        AssertJUnit.assertEquals((int)1, (int)retrieved.length);
        this.verifyResultA(retrieved[0]);
    }

    @Test
    public void testTwoMessages() {
        ConfigValidationResult[] empty = new ConfigValidationResult[]{this.getResultA(), this.getResultA()};
        ConfigValidationResult[] retrieved = this.transfer(empty);
        AssertJUnit.assertEquals((int)2, (int)retrieved.length);
        this.verifyResultA(retrieved[0]);
        this.verifyResultA(retrieved[1]);
    }

    @Test
    public void testId() {
        long id = this.transfer(10L);
        AssertJUnit.assertEquals((long)10L, (long)id);
        Long idNull = this.transfer((Long)null);
        Assert.assertNull((Object)idNull);
    }

    public void verifyResultA(ConfigValidationResult result) {
        Assert.assertNotNull((Object)result);
        AssertJUnit.assertEquals((Object)Status.ERROR, (Object)result.getStatus());
        Map messages = result.getMessages();
        AssertJUnit.assertEquals((int)1, (int)messages.size());
        Assert.assertTrue((boolean)messages.containsKey("A"));
        List messagesA = (List)messages.get("A");
        Assert.assertNotNull((Object)messagesA);
        AssertJUnit.assertEquals((int)2, (int)messagesA.size());
        AssertJUnit.assertEquals((Object)Status.WARNING, (Object)((Message)messagesA.get(0)).getStatus());
        AssertJUnit.assertEquals((String)"A", (String)((Message)messagesA.get(0)).getMessage());
        AssertJUnit.assertEquals((Object)Status.ERROR, (Object)((Message)messagesA.get(1)).getStatus());
        AssertJUnit.assertEquals((String)"B", (String)((Message)messagesA.get(1)).getMessage());
    }

    public ConfigValidationResult getResultA() {
        ConfigValidationResult result = new ConfigValidationResult();
        LinkedList<Message> messages = new LinkedList<Message>();
        messages.add(new Message(Status.WARNING, "A"));
        messages.add(new Message(Status.ERROR, "B"));
        result.addMessages("A", messages);
        return result;
    }

    private Long transfer(Long id) {
        ValidationResultBean bean = new ValidationResultBean(new ConfigValidationResult[0]);
        bean.setId(id);
        JSONObject json = bean.extract(false);
        String string = json.toString();
        JSONObject retrievedJson = JSONUtils.parse((String)string);
        ValidationResultBean retrievedBean = new ValidationResultBean();
        retrievedBean.restore(retrievedJson);
        return retrievedBean.getId();
    }

    private ConfigValidationResult[] transfer(ConfigValidationResult[] results) {
        ValidationResultBean bean = new ValidationResultBean(results);
        JSONObject json = bean.extract(false);
        String string = json.toString();
        JSONObject retrievedJson = JSONUtils.parse((String)string);
        ValidationResultBean retrievedBean = new ValidationResultBean();
        retrievedBean.restore(retrievedJson);
        return retrievedBean.getValidationResults();
    }
}

