/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.json;

import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.json.JSONUtils;
import org.apache.sqoop.json.ThrowableBean;
import org.apache.sqoop.json.util.SerializationError;
import org.json.simple.JSONObject;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

public class TestThrowableBean {
    @Test
    public void testSerialization() {
        RuntimeException ex = new RuntimeException("A");
        ex.initCause(new Exception("B"));
        Throwable retrieved = this.transfer(ex);
        AssertJUnit.assertEquals((String)"A", (String)retrieved.getMessage());
        AssertJUnit.assertEquals(RuntimeException.class, retrieved.getClass());
        AssertJUnit.assertEquals((String)"B", (String)retrieved.getCause().getMessage());
        AssertJUnit.assertEquals(Exception.class, retrieved.getCause().getClass());
        Assert.assertNull((Object)retrieved.getCause().getCause());
    }

    @Test
    public void testSqoopException() {
        SqoopException ex = new SqoopException((ErrorCode)SerializationError.SERIALIZATION_001, "Secret");
        Throwable retrieved = this.transfer(ex);
        Assert.assertNotNull((Object)retrieved);
        AssertJUnit.assertEquals(SqoopException.class, retrieved.getClass());
        SqoopException sqoopRetrieved = (SqoopException)retrieved;
        AssertJUnit.assertEquals(SerializationError.class, sqoopRetrieved.getErrorCode().getClass());
        AssertJUnit.assertEquals((Object)SerializationError.SERIALIZATION_001, (Object)sqoopRetrieved.getErrorCode());
        AssertJUnit.assertEquals((String)"SERIALIZATION_001:Attempt to pass a non-map object to MAP type. - Secret", (String)sqoopRetrieved.getMessage());
    }

    public Throwable transfer(Throwable source) {
        ThrowableBean bean = new ThrowableBean(source);
        JSONObject json = bean.extract(false);
        String string = json.toJSONString();
        JSONObject retrievedJson = JSONUtils.parse((String)string);
        ThrowableBean retrievedBean = new ThrowableBean();
        retrievedBean.restore(retrievedJson);
        return retrievedBean.getThrowable();
    }
}

