/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.json;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.sqoop.json.JSONUtils;
import org.apache.sqoop.json.SubmissionsBean;
import org.apache.sqoop.model.MSubmission;
import org.apache.sqoop.model.SubmissionError;
import org.apache.sqoop.schema.Schema;
import org.apache.sqoop.schema.type.Column;
import org.apache.sqoop.schema.type.Decimal;
import org.apache.sqoop.schema.type.Text;
import org.apache.sqoop.submission.SubmissionStatus;
import org.apache.sqoop.submission.counter.Counter;
import org.apache.sqoop.submission.counter.CounterGroup;
import org.apache.sqoop.submission.counter.Counters;
import org.json.simple.JSONObject;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

public class TestSubmissionBean {
    private static final double EPSILON = 0.01;

    @Test
    public void testTransferUnknown() {
        this.transfer(MSubmission.UNKNOWN);
        ArrayList<MSubmission> submissions = new ArrayList<MSubmission>();
        submissions.add(MSubmission.UNKNOWN);
        submissions.add(MSubmission.UNKNOWN);
        this.transfer(submissions);
    }

    @Test
    public void testTransferJobId() {
        MSubmission source = new MSubmission();
        source.setJobId(666L);
        MSubmission target = this.transfer(source);
        AssertJUnit.assertEquals((long)666L, (long)target.getJobId());
        ArrayList<MSubmission> sources = new ArrayList<MSubmission>();
        MSubmission sourcex = new MSubmission();
        sourcex.setJobId(777L);
        sources.add(sourcex);
        MSubmission sourcey = new MSubmission();
        sourcey.setJobId(888L);
        sources.add(sourcey);
        List<MSubmission> targets = this.transfer(sources);
        Assert.assertNotNull((Object)targets.get(0));
        AssertJUnit.assertEquals((long)777L, (long)targets.get(0).getJobId());
        Assert.assertNotNull((Object)targets.get(1));
        AssertJUnit.assertEquals((long)888L, (long)targets.get(1).getJobId());
    }

    @Test
    public void testTransferCreationUser() {
        String username = "admin";
        MSubmission source = new MSubmission();
        source.setCreationUser(username);
        MSubmission target = this.transfer(source);
        AssertJUnit.assertEquals((String)"admin", (String)target.getCreationUser());
        ArrayList<MSubmission> sources = new ArrayList<MSubmission>();
        MSubmission sourcex = new MSubmission();
        sourcex.setCreationUser("userA");
        sources.add(sourcex);
        MSubmission sourcey = new MSubmission();
        sourcey.setCreationUser("userB");
        sources.add(sourcey);
        List<MSubmission> targets = this.transfer(sources);
        Assert.assertNotNull((Object)targets.get(0));
        AssertJUnit.assertEquals((String)"userA", (String)targets.get(0).getCreationUser());
        Assert.assertNotNull((Object)targets.get(1));
        AssertJUnit.assertEquals((String)"userB", (String)targets.get(1).getCreationUser());
    }

    @Test
    public void testTransferCreationDate() {
        Date date = new Date();
        MSubmission source = new MSubmission();
        source.setCreationDate(date);
        MSubmission target = this.transfer(source);
        AssertJUnit.assertEquals((Object)date, (Object)target.getCreationDate());
        ArrayList<MSubmission> sources = new ArrayList<MSubmission>();
        MSubmission sourcex = new MSubmission();
        Date datex = new Date(1000L);
        sourcex.setCreationDate(datex);
        sources.add(sourcex);
        Date datey = new Date(2000L);
        MSubmission sourcey = new MSubmission();
        sourcey.setCreationDate(datey);
        sources.add(sourcey);
        List<MSubmission> targets = this.transfer(sources);
        Assert.assertNotNull((Object)targets.get(0));
        AssertJUnit.assertEquals((Object)datex, (Object)targets.get(0).getCreationDate());
        Assert.assertNotNull((Object)targets.get(1));
        AssertJUnit.assertEquals((Object)datey, (Object)targets.get(1).getCreationDate());
    }

    @Test
    public void testTransferLastUpdateUser() {
        String username = "admin";
        MSubmission source = new MSubmission();
        source.setLastUpdateUser(username);
        MSubmission target = this.transfer(source);
        AssertJUnit.assertEquals((String)"admin", (String)target.getLastUpdateUser());
        ArrayList<MSubmission> sources = new ArrayList<MSubmission>();
        MSubmission sourcex = new MSubmission();
        sourcex.setLastUpdateUser("userA");
        sources.add(sourcex);
        MSubmission sourcey = new MSubmission();
        sourcey.setLastUpdateUser("userB");
        sources.add(sourcey);
        List<MSubmission> targets = this.transfer(sources);
        Assert.assertNotNull((Object)targets.get(0));
        AssertJUnit.assertEquals((String)"userA", (String)targets.get(0).getLastUpdateUser());
        Assert.assertNotNull((Object)targets.get(1));
        AssertJUnit.assertEquals((String)"userB", (String)targets.get(1).getLastUpdateUser());
    }

    @Test
    public void testTransferLastUpdateDate() {
        Date date = new Date();
        MSubmission source = new MSubmission();
        source.setLastUpdateDate(date);
        MSubmission target = this.transfer(source);
        AssertJUnit.assertEquals((Object)date, (Object)target.getLastUpdateDate());
        ArrayList<MSubmission> sources = new ArrayList<MSubmission>();
        MSubmission sourcex = new MSubmission();
        Date datex = new Date(1000L);
        sourcex.setLastUpdateDate(datex);
        sources.add(sourcex);
        Date datey = new Date(2000L);
        MSubmission sourcey = new MSubmission();
        sourcey.setLastUpdateDate(datey);
        sources.add(sourcey);
        List<MSubmission> targets = this.transfer(sources);
        Assert.assertNotNull((Object)targets.get(0));
        AssertJUnit.assertEquals((Object)datex, (Object)targets.get(0).getLastUpdateDate());
        Assert.assertNotNull((Object)targets.get(1));
        AssertJUnit.assertEquals((Object)datey, (Object)targets.get(1).getLastUpdateDate());
    }

    @Test
    public void testTransferStatus() {
        MSubmission source = new MSubmission();
        source.setStatus(SubmissionStatus.SUCCEEDED);
        MSubmission target = this.transfer(source);
        AssertJUnit.assertEquals((Object)SubmissionStatus.SUCCEEDED, (Object)target.getStatus());
        ArrayList<MSubmission> sources = new ArrayList<MSubmission>();
        MSubmission sourcex = new MSubmission();
        sourcex.setStatus(SubmissionStatus.RUNNING);
        sources.add(sourcex);
        MSubmission sourcey = new MSubmission();
        sourcey.setStatus(SubmissionStatus.BOOTING);
        sources.add(sourcey);
        List<MSubmission> targets = this.transfer(sources);
        Assert.assertNotNull((Object)targets.get(0));
        AssertJUnit.assertEquals((Object)SubmissionStatus.RUNNING, (Object)targets.get(0).getStatus());
        Assert.assertNotNull((Object)targets.get(1));
        AssertJUnit.assertEquals((Object)SubmissionStatus.BOOTING, (Object)targets.get(1).getStatus());
    }

    @Test
    public void testTransferExternalId() {
        MSubmission source = new MSubmission();
        source.setExternalJobId("Job-x");
        MSubmission target = this.transfer(source);
        AssertJUnit.assertEquals((String)"Job-x", (String)target.getExternalJobId());
        ArrayList<MSubmission> sources = new ArrayList<MSubmission>();
        MSubmission sourcex = new MSubmission();
        sourcex.setExternalJobId("Job-y");
        sources.add(sourcex);
        MSubmission sourcey = new MSubmission();
        sourcey.setExternalJobId("Job-z");
        sources.add(sourcey);
        List<MSubmission> targets = this.transfer(sources);
        Assert.assertNotNull((Object)targets.get(0));
        AssertJUnit.assertEquals((String)"Job-y", (String)targets.get(0).getExternalJobId());
        Assert.assertNotNull((Object)targets.get(1));
        AssertJUnit.assertEquals((String)"Job-z", (String)targets.get(1).getExternalJobId());
    }

    @Test
    public void testTransferExternalLink() {
        MSubmission source = new MSubmission();
        source.setExternalLink("http://");
        MSubmission target = this.transfer(source);
        AssertJUnit.assertEquals((String)"http://", (String)target.getExternalLink());
        ArrayList<MSubmission> sources = new ArrayList<MSubmission>();
        MSubmission sourcex = new MSubmission();
        sourcex.setExternalLink("http://localhost:80");
        sources.add(sourcex);
        MSubmission sourcey = new MSubmission();
        sourcey.setExternalLink("http://localhost:8080");
        sources.add(sourcey);
        List<MSubmission> targets = this.transfer(sources);
        Assert.assertNotNull((Object)targets.get(0));
        AssertJUnit.assertEquals((String)"http://localhost:80", (String)targets.get(0).getExternalLink());
        Assert.assertNotNull((Object)targets.get(1));
        AssertJUnit.assertEquals((String)"http://localhost:8080", (String)targets.get(1).getExternalLink());
    }

    @Test
    public void testTransferErrorSummary() {
        SubmissionError error = new SubmissionError();
        MSubmission source = new MSubmission();
        error.setErrorSummary("EndOfTheWorldException");
        source.setError(error);
        MSubmission target = this.transfer(source);
        AssertJUnit.assertEquals((String)"EndOfTheWorldException", (String)target.getError().getErrorSummary());
        ArrayList<MSubmission> sources = new ArrayList<MSubmission>();
        MSubmission sourcex = new MSubmission();
        SubmissionError errorx = new SubmissionError();
        errorx.setErrorSummary("TheNewEraException");
        sourcex.setError(errorx);
        sources.add(sourcex);
        MSubmission sourcey = new MSubmission();
        SubmissionError errory = new SubmissionError();
        errory.setErrorSummary("EndOfTheWorldAgainException");
        sourcey.setError(errory);
        sources.add(sourcey);
        List<MSubmission> targets = this.transfer(sources);
        Assert.assertNotNull((Object)targets.get(0));
        AssertJUnit.assertEquals((String)"TheNewEraException", (String)targets.get(0).getError().getErrorSummary());
        Assert.assertNotNull((Object)targets.get(1));
        AssertJUnit.assertEquals((String)"EndOfTheWorldAgainException", (String)targets.get(1).getError().getErrorSummary());
    }

    @Test
    public void testTransferErrorDetails() {
        MSubmission source = new MSubmission();
        source.getError().setErrorDetails("void.java(3): line infinity");
        MSubmission target = this.transfer(source);
        AssertJUnit.assertEquals((String)"void.java(3): line infinity", (String)target.getError().getErrorDetails());
        ArrayList<MSubmission> sources = new ArrayList<MSubmission>();
        MSubmission sourcex = new MSubmission();
        sourcex.getError().setErrorDetails("void.java(4): segment fault in Java");
        sources.add(sourcex);
        MSubmission sourcey = new MSubmission();
        sourcey.getError().setErrorDetails("void.java(5): core dumps in Java");
        sources.add(sourcey);
        List<MSubmission> targets = this.transfer(sources);
        Assert.assertNotNull((Object)targets.get(0));
        AssertJUnit.assertEquals((String)"void.java(4): segment fault in Java", (String)targets.get(0).getError().getErrorDetails());
        Assert.assertNotNull((Object)targets.get(1));
        AssertJUnit.assertEquals((String)"void.java(5): core dumps in Java", (String)targets.get(1).getError().getErrorDetails());
    }

    @Test
    public void testTransferProgress() {
        MSubmission source = new MSubmission();
        source.setProgress(25.0);
        MSubmission target = this.transfer(source);
        AssertJUnit.assertEquals((double)25.0, (double)target.getProgress(), (double)0.01);
        ArrayList<MSubmission> sources = new ArrayList<MSubmission>();
        MSubmission sourcex = new MSubmission();
        sourcex.setProgress(50.0);
        sources.add(sourcex);
        MSubmission sourcey = new MSubmission();
        sourcey.setProgress(99.9);
        sources.add(sourcey);
        List<MSubmission> targets = this.transfer(sources);
        Assert.assertNotNull((Object)targets.get(0));
        AssertJUnit.assertEquals((double)50.0, (double)targets.get(0).getProgress(), (double)0.01);
        Assert.assertNotNull((Object)targets.get(1));
        AssertJUnit.assertEquals((double)99.9, (double)targets.get(1).getProgress(), (double)0.01);
    }

    @Test
    public void testTransferCounters() {
        Counters counters = new Counters();
        counters.addCounterGroup(new CounterGroup("A").addCounter(new Counter("X", 1L)).addCounter(new Counter("Y", 2L)));
        counters.addCounterGroup(new CounterGroup("B").addCounter(new Counter("XX", 11L)).addCounter(new Counter("YY", 22L)));
        MSubmission source = new MSubmission();
        source.setCounters(counters);
        Counters target = this.transfer(source).getCounters();
        CounterGroup group = target.getCounterGroup("A");
        Assert.assertNotNull((Object)group);
        Counter counter = group.getCounter("X");
        Assert.assertNotNull((Object)counter);
        AssertJUnit.assertEquals((long)1L, (long)counter.getValue());
        counter = group.getCounter("Y");
        Assert.assertNotNull((Object)counter);
        AssertJUnit.assertEquals((long)2L, (long)counter.getValue());
        target = this.transfer(source).getCounters();
        group = target.getCounterGroup("B");
        Assert.assertNotNull((Object)group);
        counter = group.getCounter("XX");
        Assert.assertNotNull((Object)counter);
        AssertJUnit.assertEquals((long)11L, (long)counter.getValue());
        counter = group.getCounter("YY");
        Assert.assertNotNull((Object)counter);
        AssertJUnit.assertEquals((long)22L, (long)counter.getValue());
        Counters countersx = new Counters();
        countersx.addCounterGroup(new CounterGroup("C").addCounter(new Counter("XXX", 111L)).addCounter(new Counter("YYY", 222L)));
        countersx.addCounterGroup(new CounterGroup("D").addCounter(new Counter("XXXX", 1111L)).addCounter(new Counter("YYYY", 2222L)));
        Counters countersy = new Counters();
        countersy.addCounterGroup(new CounterGroup("E").addCounter(new Counter("XXXXX", 11111L)).addCounter(new Counter("YYYYY", 22222L)));
        countersy.addCounterGroup(new CounterGroup("F").addCounter(new Counter("XXXXXX", 111111L)).addCounter(new Counter("YYYYYY", 222222L)));
        ArrayList<MSubmission> sources = new ArrayList<MSubmission>();
        MSubmission sourcex = new MSubmission();
        sourcex.setCounters(countersx);
        sources.add(sourcex);
        MSubmission sourcey = new MSubmission();
        sourcey.setCounters(countersy);
        sources.add(sourcey);
        List<MSubmission> targets = this.transfer(sources);
        Assert.assertNotNull((Object)targets.get(0));
        target = targets.get(0).getCounters();
        group = target.getCounterGroup("C");
        Assert.assertNotNull((Object)group);
        counter = group.getCounter("XXX");
        Assert.assertNotNull((Object)counter);
        AssertJUnit.assertEquals((long)111L, (long)counter.getValue());
        counter = group.getCounter("YYY");
        Assert.assertNotNull((Object)counter);
        AssertJUnit.assertEquals((long)222L, (long)counter.getValue());
        group = target.getCounterGroup("D");
        Assert.assertNotNull((Object)group);
        counter = group.getCounter("XXXX");
        Assert.assertNotNull((Object)counter);
        AssertJUnit.assertEquals((long)1111L, (long)counter.getValue());
        counter = group.getCounter("YYYY");
        Assert.assertNotNull((Object)counter);
        AssertJUnit.assertEquals((long)2222L, (long)counter.getValue());
        Assert.assertNotNull((Object)targets.get(1));
        target = targets.get(1).getCounters();
        group = target.getCounterGroup("E");
        Assert.assertNotNull((Object)group);
        counter = group.getCounter("XXXXX");
        Assert.assertNotNull((Object)counter);
        AssertJUnit.assertEquals((long)11111L, (long)counter.getValue());
        counter = group.getCounter("YYYYY");
        Assert.assertNotNull((Object)counter);
        AssertJUnit.assertEquals((long)22222L, (long)counter.getValue());
        group = target.getCounterGroup("F");
        Assert.assertNotNull((Object)group);
        counter = group.getCounter("XXXXXX");
        Assert.assertNotNull((Object)counter);
        AssertJUnit.assertEquals((long)111111L, (long)counter.getValue());
        counter = group.getCounter("YYYYYY");
        Assert.assertNotNull((Object)counter);
        AssertJUnit.assertEquals((long)222222L, (long)counter.getValue());
    }

    @Test
    public void testTransferFromSchema() {
        MSubmission source = new MSubmission();
        source.setFromSchema(this.getSchema());
        Schema target = this.transfer(source).getFromSchema();
        Assert.assertNotNull((Object)target);
        AssertJUnit.assertEquals((Object)this.getSchema(), (Object)target);
    }

    @Test
    public void testTransferToSchema() {
        MSubmission source = new MSubmission();
        source.setToSchema(this.getSchema());
        Schema target = this.transfer(source).getToSchema();
        Assert.assertNotNull((Object)target);
        AssertJUnit.assertEquals((Object)this.getSchema(), (Object)target);
    }

    private Schema getSchema() {
        return new Schema("schema").addColumn((Column)new Text("col1")).addColumn((Column)new Decimal("col2", Integer.valueOf(5), Integer.valueOf(2)));
    }

    private MSubmission transfer(MSubmission submission) {
        SubmissionsBean bean = new SubmissionsBean(submission);
        JSONObject json = bean.extract(false);
        String string = json.toString();
        JSONObject retrievedJson = JSONUtils.parse((String)string);
        SubmissionsBean retrievedBean = new SubmissionsBean();
        retrievedBean.restore(retrievedJson);
        return (MSubmission)retrievedBean.getSubmissions().get(0);
    }

    private List<MSubmission> transfer(List<MSubmission> submissions) {
        SubmissionsBean bean = new SubmissionsBean(submissions);
        JSONObject json = bean.extract(false);
        String string = json.toString();
        JSONObject retrievedJson = JSONUtils.parse((String)string);
        SubmissionsBean retrievedBean = new SubmissionsBean();
        retrievedBean.restore(retrievedJson);
        return retrievedBean.getSubmissions();
    }
}

