/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.json;

import java.util.ArrayList;
import java.util.Date;
import org.apache.sqoop.json.JSONUtils;
import org.apache.sqoop.json.LinksBean;
import org.apache.sqoop.json.util.BeanTestUtil;
import org.apache.sqoop.model.MConfig;
import org.apache.sqoop.model.MLink;
import org.apache.sqoop.model.MStringInput;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

public class TestLinksBean {
    @Test
    public void testLinksSerialization() {
        Date created = new Date();
        Date updated = new Date();
        MLink link1 = BeanTestUtil.createLink("ahoj", "link1", 666L, created, updated);
        MLink link2 = BeanTestUtil.createLink("jhoa", "link2", 888L, created, updated);
        ArrayList<MLink> links = new ArrayList<MLink>();
        links.add(link1);
        links.add(link2);
        MStringInput input = (MStringInput)((MConfig)link1.getConnectorLinkConfig().getConfigs().get(0)).getInputs().get(0);
        input.setValue((Object)"Hi there!");
        LinksBean linkBean = new LinksBean(links);
        JSONObject json = linkBean.extract(false);
        JSONArray linksObj = (JSONArray)json.get((Object)"links");
        JSONObject linkObj = (JSONObject)linksObj.get(0);
        JSONArray linkConfigs = (JSONArray)linkObj.get((Object)"link-config-values");
        JSONObject linkConfig = (JSONObject)linkConfigs.get(0);
        JSONArray inputs = (JSONArray)linkConfig.get((Object)"inputs");
        for (Object inp : inputs) {
            Assert.assertTrue((boolean)((JSONObject)inp).containsKey((Object)"sensitive"));
        }
        String linkJsonString = json.toJSONString();
        JSONObject parsedLinkJson = JSONUtils.parse((String)linkJsonString);
        LinksBean retrievedBean = new LinksBean();
        retrievedBean.restore(parsedLinkJson);
        MLink targetLink1 = (MLink)retrievedBean.getLinks().get(0);
        MLink targetLink2 = (MLink)retrievedBean.getLinks().get(1);
        AssertJUnit.assertEquals((long)666L, (long)targetLink1.getPersistenceId());
        AssertJUnit.assertEquals((long)888L, (long)targetLink2.getPersistenceId());
        AssertJUnit.assertEquals((String)"link1", (String)targetLink1.getName());
        AssertJUnit.assertEquals((String)"link2", (String)targetLink2.getName());
        AssertJUnit.assertEquals((String)"admin", (String)targetLink1.getCreationUser());
        AssertJUnit.assertEquals((Object)created, (Object)targetLink1.getCreationDate());
        AssertJUnit.assertEquals((String)"user", (String)targetLink1.getLastUpdateUser());
        AssertJUnit.assertEquals((Object)updated, (Object)targetLink1.getLastUpdateDate());
        AssertJUnit.assertEquals((boolean)false, (boolean)targetLink1.getEnabled());
        MStringInput targetInput = (MStringInput)((MConfig)targetLink1.getConnectorLinkConfig().getConfigs().get(0)).getInputs().get(0);
        AssertJUnit.assertEquals((String)"Hi there!", (String)((String)targetInput.getValue()));
    }
}

