/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.json;

import java.util.Date;
import org.apache.sqoop.json.JSONUtils;
import org.apache.sqoop.json.LinkBean;
import org.apache.sqoop.json.util.BeanTestUtil;
import org.apache.sqoop.model.MConfig;
import org.apache.sqoop.model.MLink;
import org.apache.sqoop.model.MStringInput;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

public class TestLinkBean {
    @Test
    public void testLinkSerialization() {
        Date created = new Date();
        Date updated = new Date();
        MLink link = BeanTestUtil.createLink("ahoj", "link1", 22L, created, updated);
        MStringInput input = (MStringInput)((MConfig)link.getConnectorLinkConfig().getConfigs().get(0)).getInputs().get(0);
        input.setValue((Object)"Hi there!");
        LinkBean linkBean = new LinkBean(link);
        JSONObject json = linkBean.extract(false);
        JSONObject linkObj = (JSONObject)json.get((Object)"link");
        JSONArray linkConfigs = (JSONArray)linkObj.get((Object)"link-config-values");
        JSONObject linkConfig = (JSONObject)linkConfigs.get(0);
        JSONArray inputs = (JSONArray)linkConfig.get((Object)"inputs");
        for (Object in : inputs) {
            Assert.assertTrue((boolean)((JSONObject)in).containsKey((Object)"sensitive"));
        }
        String linkJsonString = json.toJSONString();
        JSONObject parsedLinkJson = JSONUtils.parse((String)linkJsonString);
        LinkBean retrievedBean = new LinkBean();
        retrievedBean.restore(parsedLinkJson);
        MLink retrievedLink = (MLink)retrievedBean.getLinks().get(0);
        AssertJUnit.assertEquals((long)22L, (long)retrievedLink.getPersistenceId());
        AssertJUnit.assertEquals((String)"link1", (String)retrievedLink.getName());
        AssertJUnit.assertEquals((String)"admin", (String)retrievedLink.getCreationUser());
        AssertJUnit.assertEquals((Object)created, (Object)retrievedLink.getCreationDate());
        AssertJUnit.assertEquals((String)"user", (String)retrievedLink.getLastUpdateUser());
        AssertJUnit.assertEquals((Object)updated, (Object)retrievedLink.getLastUpdateDate());
        AssertJUnit.assertEquals((boolean)false, (boolean)retrievedLink.getEnabled());
        MStringInput retrievedLinkInput = (MStringInput)((MConfig)retrievedLink.getConnectorLinkConfig().getConfigs().get(0)).getInputs().get(0);
        AssertJUnit.assertEquals((String)"Hi there!", (String)((String)retrievedLinkInput.getValue()));
    }

    @Test
    public void testSensitivityFilter() {
        Date created = new Date();
        Date updated = new Date();
        MLink link = BeanTestUtil.createLink("ahoj", "link1", 22L, created, updated);
        MStringInput input = (MStringInput)((MConfig)link.getConnectorLinkConfig().getConfigs().get(0)).getInputs().get(0);
        input.setValue((Object)"Hi there!");
        LinkBean bean = new LinkBean(link);
        JSONObject json = bean.extract(false);
        JSONObject jsonFiltered = bean.extract(true);
        JSONObject linkObj = (JSONObject)json.get((Object)"link");
        JSONArray linkConfigsObj = (JSONArray)linkObj.get((Object)"link-config-values");
        JSONObject linkConfigObj = (JSONObject)linkConfigsObj.get(0);
        JSONArray inputs = (JSONArray)linkConfigObj.get((Object)"inputs");
        AssertJUnit.assertEquals((int)3, (int)inputs.size());
        JSONObject password = (JSONObject)inputs.get(2);
        Assert.assertTrue((boolean)password.containsKey((Object)"value"));
        linkObj = (JSONObject)jsonFiltered.get((Object)"link");
        linkConfigsObj = (JSONArray)linkObj.get((Object)"link-config-values");
        linkConfigObj = (JSONObject)linkConfigsObj.get(0);
        inputs = (JSONArray)linkConfigObj.get((Object)"inputs");
        AssertJUnit.assertEquals((int)3, (int)inputs.size());
        password = (JSONObject)inputs.get(2);
        Assert.assertFalse((boolean)password.containsKey((Object)"value"));
    }
}

