/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.json;

import java.util.ArrayList;
import java.util.Date;
import org.apache.sqoop.json.JSONUtils;
import org.apache.sqoop.json.JobsBean;
import org.apache.sqoop.json.util.BeanTestUtil;
import org.apache.sqoop.model.MConfig;
import org.apache.sqoop.model.MJob;
import org.apache.sqoop.model.MStringInput;
import org.json.simple.JSONObject;
import org.json.simple.parser.ParseException;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

public class TestJobsBean {
    @Test
    public void testJobsSerialization() throws ParseException {
        Date created = new Date();
        Date updated = new Date();
        MJob job1 = BeanTestUtil.createJob("ahoj", "The big Job", 22L, created, updated);
        MJob job2 = BeanTestUtil.createJob("ahoj", "The small Job", 44L, created, updated);
        ArrayList<MJob> jobs = new ArrayList<MJob>();
        jobs.add(job1);
        jobs.add(job2);
        MStringInput input = (MStringInput)((MConfig)job1.getFromJobConfig().getConfigs().get(0)).getInputs().get(0);
        input.setValue((Object)"Hi there!");
        input = (MStringInput)((MConfig)job1.getToJobConfig().getConfigs().get(0)).getInputs().get(0);
        input.setValue((Object)"Hi there again!");
        JobsBean jobsBean = new JobsBean(jobs);
        JSONObject json = jobsBean.extract(false);
        String jobJsonString = json.toJSONString();
        JSONObject parsedJobsJson = JSONUtils.parse((String)jobJsonString);
        JobsBean parsedJobsBean = new JobsBean();
        parsedJobsBean.restore(parsedJobsJson);
        MJob retrievedJob1 = (MJob)parsedJobsBean.getJobs().get(0);
        MJob retrievedJob2 = (MJob)parsedJobsBean.getJobs().get(1);
        AssertJUnit.assertEquals((long)22L, (long)retrievedJob1.getPersistenceId());
        AssertJUnit.assertEquals((String)"The big Job", (String)retrievedJob1.getName());
        AssertJUnit.assertEquals((long)44L, (long)retrievedJob2.getPersistenceId());
        AssertJUnit.assertEquals((String)"The small Job", (String)retrievedJob2.getName());
        AssertJUnit.assertEquals((long)retrievedJob1.getFromLinkId(), (long)1L);
        AssertJUnit.assertEquals((long)retrievedJob1.getToLinkId(), (long)2L);
        AssertJUnit.assertEquals((long)retrievedJob1.getFromConnectorId(), (long)1L);
        AssertJUnit.assertEquals((long)retrievedJob1.getToConnectorId(), (long)2L);
        AssertJUnit.assertEquals((Object)created, (Object)retrievedJob1.getCreationDate());
        AssertJUnit.assertEquals((Object)updated, (Object)retrievedJob1.getLastUpdateDate());
        AssertJUnit.assertEquals((boolean)false, (boolean)retrievedJob1.getEnabled());
        MStringInput targetInput = (MStringInput)((MConfig)retrievedJob1.getFromJobConfig().getConfigs().get(0)).getInputs().get(0);
        AssertJUnit.assertEquals((String)"Hi there!", (String)((String)targetInput.getValue()));
        targetInput = (MStringInput)((MConfig)retrievedJob1.getToJobConfig().getConfigs().get(0)).getInputs().get(0);
        AssertJUnit.assertEquals((String)"Hi there again!", (String)((String)targetInput.getValue()));
    }
}

