/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.json;

import java.util.Date;
import org.apache.sqoop.json.JSONUtils;
import org.apache.sqoop.json.JobBean;
import org.apache.sqoop.json.util.BeanTestUtil;
import org.apache.sqoop.model.MConfig;
import org.apache.sqoop.model.MJob;
import org.apache.sqoop.model.MStringInput;
import org.json.simple.JSONObject;
import org.json.simple.parser.ParseException;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

public class TestJobBean {
    @Test
    public void testJobSerialization() throws ParseException {
        Date created = new Date();
        Date updated = new Date();
        MJob job = BeanTestUtil.createJob("ahoj", "The big Job", 22L, created, updated);
        MStringInput input = (MStringInput)((MConfig)job.getFromJobConfig().getConfigs().get(0)).getInputs().get(0);
        input.setValue((Object)"Hi there!");
        input = (MStringInput)((MConfig)job.getToJobConfig().getConfigs().get(0)).getInputs().get(0);
        input.setValue((Object)"Hi there again!");
        JobBean jobBean = new JobBean(job);
        JSONObject json = jobBean.extract(false);
        String jobJsonString = json.toJSONString();
        JSONObject parsedJobJson = JSONUtils.parse((String)jobJsonString);
        JobBean parsedJobBean = new JobBean();
        parsedJobBean.restore(parsedJobJson);
        MJob target = (MJob)parsedJobBean.getJobs().get(0);
        AssertJUnit.assertEquals((long)22L, (long)target.getPersistenceId());
        AssertJUnit.assertEquals((String)"The big Job", (String)target.getName());
        AssertJUnit.assertEquals((long)target.getFromLinkId(), (long)1L);
        AssertJUnit.assertEquals((long)target.getToLinkId(), (long)2L);
        AssertJUnit.assertEquals((long)target.getFromConnectorId(), (long)1L);
        AssertJUnit.assertEquals((long)target.getToConnectorId(), (long)2L);
        AssertJUnit.assertEquals((Object)created, (Object)target.getCreationDate());
        AssertJUnit.assertEquals((Object)updated, (Object)target.getLastUpdateDate());
        AssertJUnit.assertEquals((boolean)false, (boolean)target.getEnabled());
        MStringInput targetInput = (MStringInput)((MConfig)target.getFromJobConfig().getConfigs().get(0)).getInputs().get(0);
        AssertJUnit.assertEquals((String)"Hi there!", (String)((String)targetInput.getValue()));
        targetInput = (MStringInput)((MConfig)target.getToJobConfig().getConfigs().get(0)).getInputs().get(0);
        AssertJUnit.assertEquals((String)"Hi there again!", (String)((String)targetInput.getValue()));
    }
}

