/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.json;

import java.io.Reader;
import java.io.StringReader;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.json.JSONUtils;
import org.json.simple.JSONObject;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

public class TestJSONUtils {
    @Test
    public void testString() {
        JSONObject object = JSONUtils.parse((String)"{\"id\":3}");
        AssertJUnit.assertEquals((Object)3L, (Object)object.get((Object)"id"));
    }

    @Test(expectedExceptions={SqoopException.class})
    public void testStringInvalid() {
        JSONUtils.parse((String)"{");
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testStringNull() {
        JSONUtils.parse((String)null);
    }

    @Test
    public void testReader() {
        JSONObject object = JSONUtils.parse((Reader)new StringReader("{\"id\":3}"));
        AssertJUnit.assertEquals((Object)3L, (Object)object.get((Object)"id"));
    }

    @Test(expectedExceptions={SqoopException.class})
    public void testReaderInvalid() {
        JSONUtils.parse((Reader)new StringReader("{"));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testReaderNull() {
        JSONUtils.parse((Reader)null);
    }
}

