/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.json;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.ResourceBundle;
import org.apache.sqoop.json.ConnectorsBean;
import org.apache.sqoop.json.JSONUtils;
import org.apache.sqoop.json.util.BeanTestUtil;
import org.apache.sqoop.json.util.ConfigTestUtil;
import org.apache.sqoop.model.MConnector;
import org.json.simple.JSONObject;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

public class TestConnectorsBean {
    @Test
    public void testConnectorsSerialization() {
        LinkedList<MConnector> connectors = new LinkedList<MConnector>();
        connectors.add(BeanTestUtil.getConnector(1L, "jdbc"));
        connectors.add(BeanTestUtil.getConnector(2L, "mysql"));
        HashMap<Long, ResourceBundle> configBundles = new HashMap<Long, ResourceBundle>();
        configBundles.put(1L, ConfigTestUtil.getResourceBundle());
        configBundles.put(2L, ConfigTestUtil.getResourceBundle());
        ConnectorsBean connectorsBean = new ConnectorsBean(connectors, configBundles);
        JSONObject connectorsJSON = connectorsBean.extract(false);
        String connectorsJSONString = connectorsJSON.toJSONString();
        JSONObject parsedConnectors = JSONUtils.parse((String)connectorsJSONString);
        ConnectorsBean parsedConnectorsBean = new ConnectorsBean();
        parsedConnectorsBean.restore(parsedConnectors);
        AssertJUnit.assertEquals((int)connectors.size(), (int)parsedConnectorsBean.getConnectors().size());
        AssertJUnit.assertEquals(connectors.get(0), parsedConnectorsBean.getConnectors().get(0));
        AssertJUnit.assertEquals(connectors.get(1), parsedConnectorsBean.getConnectors().get(1));
        ResourceBundle retrievedBundle = (ResourceBundle)parsedConnectorsBean.getResourceBundles().get(1L);
        Assert.assertNotNull((Object)retrievedBundle);
        AssertJUnit.assertEquals((String)"a", (String)retrievedBundle.getString("a"));
        AssertJUnit.assertEquals((String)"b", (String)retrievedBundle.getString("b"));
    }

    @Test
    public void testSingleDirection() {
        LinkedList<MConnector> connectors = new LinkedList<MConnector>();
        connectors.add(BeanTestUtil.getConnector(1L, "jdbc", true, false));
        connectors.add(BeanTestUtil.getConnector(2L, "mysql", false, true));
        HashMap<Long, ResourceBundle> bundles = new HashMap<Long, ResourceBundle>();
        bundles.put(1L, ConfigTestUtil.getResourceBundle());
        bundles.put(2L, ConfigTestUtil.getResourceBundle());
        ConnectorsBean bean = new ConnectorsBean(connectors, bundles);
        JSONObject json = bean.extract(false);
        String string = json.toJSONString();
        JSONObject retrievedJson = JSONUtils.parse((String)string);
        ConnectorsBean retrievedBean = new ConnectorsBean();
        retrievedBean.restore(retrievedJson);
        AssertJUnit.assertEquals((int)connectors.size(), (int)retrievedBean.getConnectors().size());
        AssertJUnit.assertEquals(connectors.get(0), retrievedBean.getConnectors().get(0));
        AssertJUnit.assertEquals(connectors.get(1), retrievedBean.getConnectors().get(1));
    }

    @Test
    public void testNoDirection() {
        LinkedList<MConnector> connectors = new LinkedList<MConnector>();
        connectors.add(BeanTestUtil.getConnector(1L, "jdbc", false, false));
        connectors.add(BeanTestUtil.getConnector(2L, "mysql", false, false));
        HashMap<Long, ResourceBundle> bundles = new HashMap<Long, ResourceBundle>();
        bundles.put(1L, ConfigTestUtil.getResourceBundle());
        bundles.put(2L, ConfigTestUtil.getResourceBundle());
        ConnectorsBean bean = new ConnectorsBean(connectors, bundles);
        JSONObject json = bean.extract(false);
        String string = json.toJSONString();
        JSONObject retrievedJson = JSONUtils.parse((String)string);
        ConnectorsBean retrievedBean = new ConnectorsBean();
        retrievedBean.restore(retrievedJson);
        AssertJUnit.assertEquals((int)connectors.size(), (int)retrievedBean.getConnectors().size());
        AssertJUnit.assertEquals(connectors.get(0), retrievedBean.getConnectors().get(0));
        AssertJUnit.assertEquals(connectors.get(1), retrievedBean.getConnectors().get(1));
    }
}

