/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.json;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.ResourceBundle;
import org.apache.sqoop.json.ConnectorBean;
import org.apache.sqoop.json.JSONUtils;
import org.apache.sqoop.json.util.BeanTestUtil;
import org.apache.sqoop.json.util.ConfigTestUtil;
import org.apache.sqoop.model.MConnector;
import org.json.simple.JSONObject;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

public class TestConnectorBean {
    @Test
    public void testConnectorSerialization() {
        LinkedList<MConnector> connectors = new LinkedList<MConnector>();
        connectors.add(BeanTestUtil.getConnector(1L, "jdbc"));
        HashMap<Long, ResourceBundle> configBundles = new HashMap<Long, ResourceBundle>();
        configBundles.put(1L, ConfigTestUtil.getResourceBundle());
        ConnectorBean connectorBean = new ConnectorBean(connectors, configBundles);
        JSONObject connectorJSON = connectorBean.extract(false);
        String connectorJSONString = connectorJSON.toJSONString();
        JSONObject parsedConnectors = JSONUtils.parse((String)connectorJSONString);
        ConnectorBean parsedConnectorBean = new ConnectorBean();
        parsedConnectorBean.restore(parsedConnectors);
        AssertJUnit.assertEquals((int)connectors.size(), (int)1);
        AssertJUnit.assertEquals((int)connectors.size(), (int)parsedConnectorBean.getConnectors().size());
        AssertJUnit.assertEquals(connectors.get(0), parsedConnectorBean.getConnectors().get(0));
        ResourceBundle retrievedBundle = (ResourceBundle)parsedConnectorBean.getResourceBundles().get(1L);
        Assert.assertNotNull((Object)retrievedBundle);
        AssertJUnit.assertEquals((String)"a", (String)retrievedBundle.getString("a"));
        AssertJUnit.assertEquals((String)"b", (String)retrievedBundle.getString("b"));
    }
}

