/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.validation;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.validation.Status;
import org.apache.sqoop.validation.ValidationError;

public class Validation {
    Class klass;
    Status status;
    Map<FormInput, Message> messages;

    public Validation(Class klass) {
        this.klass = klass;
        this.status = Status.getDefault();
        this.messages = new HashMap<FormInput, Message>();
    }

    public Validation(Status status, Map<FormInput, Message> messages) {
        this.status = status;
        this.messages = messages;
    }

    public Status getStatus() {
        return this.status;
    }

    public Map<FormInput, Message> getMessages() {
        return this.messages;
    }

    public void addMessage(Status status, String form, String message) {
        this.addMessage(status, form, null, message);
    }

    public void addMessage(Status status, String form, String input, String message) {
        Field formField;
        if (this.klass == null) {
            throw new SqoopException(ValidationError.VALIDATION_0001);
        }
        assert (form != null);
        assert (message != null);
        try {
            formField = this.klass.getDeclaredField(form);
        }
        catch (NoSuchFieldException e) {
            throw new SqoopException(ValidationError.VALIDATION_0002, "Can't get form " + form + " from " + this.klass.getName(), e);
        }
        if (input == null) {
            this.setMessage(status, form, input, message);
            return;
        }
        try {
            formField.getType().getDeclaredField(input);
        }
        catch (NoSuchFieldException e) {
            throw new SqoopException(ValidationError.VALIDATION_0002, "Can't get input " + input + " from form" + formField.getType().getName(), e);
        }
        this.setMessage(status, form, input, message);
    }

    private void setMessage(Status status, String form, String input, String message) {
        this.status = Status.getWorstStatus(this.status, status);
        this.messages.put(new FormInput(form, input), new Message(status, message));
    }

    public static class FormInput {
        private String form;
        private String input;

        public FormInput(String form, String input) {
            this.form = form;
            this.input = input;
        }

        public FormInput(String formInput) {
            assert (formInput != null);
            String[] parts = formInput.split("\\.");
            if (formInput.isEmpty() || parts.length != 1 && parts.length != 2) {
                throw new SqoopException((ErrorCode)ValidationError.VALIDATION_0003, "Specification " + formInput + " is not in valid format form.input");
            }
            this.form = parts[0];
            if (parts.length == 2) {
                this.input = parts[1];
            }
        }

        public String getForm() {
            return this.form;
        }

        public String getInput() {
            return this.input;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FormInput formInput = (FormInput)o;
            if (this.form != null ? !this.form.equals(formInput.form) : formInput.form != null) {
                return false;
            }
            return !(this.input != null ? !this.input.equals(formInput.input) : formInput.input != null);
        }

        public int hashCode() {
            int result = this.form != null ? this.form.hashCode() : 0;
            result = 31 * result + (this.input != null ? this.input.hashCode() : 0);
            return result;
        }

        public String toString() {
            if (this.input == null) {
                return this.form;
            }
            return this.form + "." + this.input;
        }
    }

    public static class Message {
        private Status status;
        private String message;

        public Message(Status status, String message) {
            this.status = status;
            this.message = message;
        }

        public Status getStatus() {
            return this.status;
        }

        public String getMessage() {
            return this.message;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Message)) {
                return false;
            }
            Message message1 = (Message)o;
            if (this.message != null ? !this.message.equals(message1.message) : message1.message != null) {
                return false;
            }
            return this.status == message1.status;
        }

        public int hashCode() {
            int result = this.status != null ? this.status.hashCode() : 0;
            result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "{" + this.status.name() + ": " + this.message + "}";
        }
    }
}

