/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.model.MBooleanInput;
import org.apache.sqoop.model.MClonable;
import org.apache.sqoop.model.MEnumInput;
import org.apache.sqoop.model.MForm;
import org.apache.sqoop.model.MInput;
import org.apache.sqoop.model.MIntegerInput;
import org.apache.sqoop.model.MMapInput;
import org.apache.sqoop.model.MStringInput;
import org.apache.sqoop.model.ModelError;

public class MFormList
implements MClonable {
    private final List<MForm> forms;

    public MFormList(List<MForm> forms) {
        this.forms = forms;
    }

    public List<MForm> getForms() {
        return this.forms;
    }

    public MForm getForm(String formName) {
        for (MForm form : this.forms) {
            if (!formName.equals(form.getName())) continue;
            return form;
        }
        throw new SqoopException((ErrorCode)ModelError.MODEL_010, "Form name: " + formName);
    }

    public MInput getInput(String name) {
        String[] parts = name.split("\\.");
        if (parts.length != 2) {
            throw new SqoopException((ErrorCode)ModelError.MODEL_009, name);
        }
        return this.getForm(parts[0]).getInput(name);
    }

    public MStringInput getStringInput(String name) {
        return (MStringInput)this.getInput(name);
    }

    public MEnumInput getEnumInput(String name) {
        return (MEnumInput)this.getInput(name);
    }

    public MIntegerInput getIntegerInput(String name) {
        return (MIntegerInput)this.getInput(name);
    }

    public MMapInput getMapInput(String name) {
        return (MMapInput)this.getInput(name);
    }

    public MBooleanInput getBooleanInput(String name) {
        return (MBooleanInput)this.getInput(name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MFormList)) {
            return false;
        }
        MFormList mFormList = (MFormList)o;
        return this.forms.equals(mFormList.forms);
    }

    public int hashCode() {
        int result = super.hashCode();
        for (MForm form : this.forms) {
            result = 31 * result + form.hashCode();
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Forms: ");
        for (MForm form : this.forms) {
            sb.append(form.toString());
        }
        return sb.toString();
    }

    @Override
    public MFormList clone(boolean cloneWithValue) {
        ArrayList<MForm> copyForms = null;
        if (this.getForms() != null) {
            copyForms = new ArrayList<MForm>();
            for (MForm itr : this.getForms()) {
                MForm newForm = itr.clone(cloneWithValue);
                newForm.setPersistenceId(itr.getPersistenceId());
                copyForms.add(newForm);
            }
        }
        MFormList copyFormList = new MFormList(copyForms);
        return copyFormList;
    }
}

