/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.model;

import org.apache.sqoop.model.MInput;
import org.apache.sqoop.model.MInputType;

public class MBooleanInput
extends MInput<Boolean> {
    public MBooleanInput(String name, boolean sensitive) {
        super(name, sensitive);
    }

    @Override
    public String getUrlSafeValueString() {
        return (Boolean)this.getValue() != false ? "true" : "false";
    }

    @Override
    public void restoreFromUrlSafeValueString(String valueString) {
        if ("true".equals(valueString)) {
            this.setValue(true);
        } else {
            this.setValue(false);
        }
    }

    @Override
    public MInputType getType() {
        return MInputType.BOOLEAN;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof MBooleanInput)) {
            return false;
        }
        MBooleanInput mbi = (MBooleanInput)other;
        return this.getName().equals(mbi.getName()) && this.isSensitive() == mbi.isSensitive();
    }

    @Override
    public int hashCode() {
        return ((Boolean)this.getValue()).hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.getValue() == null;
    }

    @Override
    public void setEmpty() {
        this.setValue(null);
    }

    @Override
    public Object clone(boolean cloneWithValue) {
        MBooleanInput copy = new MBooleanInput(this.getName(), this.isSensitive());
        copy.setPersistenceId(this.getPersistenceId());
        if (cloneWithValue) {
            copy.setValue(this.getValue());
        }
        return copy;
    }
}

