/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.json.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.json.util.SerializationError;
import org.apache.sqoop.model.MBooleanInput;
import org.apache.sqoop.model.MEnumInput;
import org.apache.sqoop.model.MForm;
import org.apache.sqoop.model.MFormType;
import org.apache.sqoop.model.MInput;
import org.apache.sqoop.model.MInputType;
import org.apache.sqoop.model.MIntegerInput;
import org.apache.sqoop.model.MMapInput;
import org.apache.sqoop.model.MStringInput;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public final class FormSerialization {
    public static final String ALL = "all";
    public static final String ID = "id";
    public static final String NAME = "name";
    public static final String VERSION = "version";
    public static final String FRAMEWORK_VERSION = "framework-version";
    public static final String CLASS = "class";
    public static final String ENABLED = "enabled";
    public static final String CREATION_USER = "creation-user";
    public static final String CREATION_DATE = "creation-date";
    public static final String UPDATE_USER = "update-user";
    public static final String UPDATE_DATE = "update-date";
    public static final String CON_FORMS = "con-forms";
    public static final String JOB_FORMS = "job-forms";
    public static final String FORM_NAME = "name";
    public static final String FORM_TYPE = "type";
    public static final String FORM_INPUTS = "inputs";
    public static final String FORM_INPUT_NAME = "name";
    public static final String FORM_INPUT_TYPE = "type";
    public static final String FORM_INPUT_SENSITIVE = "sensitive";
    public static final String FORM_INPUT_SIZE = "size";
    public static final String FORM_INPUT_VALUE = "value";
    public static final String FORM_INPUT_VALUES = "values";

    public static JSONArray extractForms(List<MForm> mForms, boolean skipSensitive) {
        JSONArray forms = new JSONArray();
        for (MForm mForm : mForms) {
            forms.add((Object)FormSerialization.extractForm(mForm, skipSensitive));
        }
        return forms;
    }

    public static JSONObject extractForm(MForm mForm, boolean skipSensitive) {
        JSONObject form = new JSONObject();
        form.put((Object)ID, (Object)mForm.getPersistenceId());
        form.put((Object)"name", (Object)mForm.getName());
        form.put((Object)"type", (Object)MFormType.CONNECTION.toString());
        JSONArray mInputs = new JSONArray();
        form.put((Object)FORM_INPUTS, (Object)mInputs);
        for (MInput<?> mInput : mForm.getInputs()) {
            JSONObject input = new JSONObject();
            input.put((Object)ID, (Object)mInput.getPersistenceId());
            input.put((Object)"name", (Object)mInput.getName());
            input.put((Object)"type", (Object)mInput.getType().toString());
            input.put((Object)FORM_INPUT_SENSITIVE, (Object)mInput.isSensitive());
            if (mInput.getType() == MInputType.STRING) {
                input.put((Object)FORM_INPUT_SIZE, (Object)((MStringInput)mInput).getMaxLength());
            }
            if (mInput.getType() == MInputType.ENUM) {
                input.put((Object)FORM_INPUT_VALUES, (Object)StringUtils.join((Object[])((MEnumInput)mInput).getValues(), (String)","));
            }
            if (!(mInput.isEmpty() || skipSensitive && mInput.isSensitive())) {
                if (mInput.getType() == MInputType.MAP) {
                    input.put((Object)FORM_INPUT_VALUE, mInput.getValue());
                } else {
                    input.put((Object)FORM_INPUT_VALUE, (Object)mInput.getUrlSafeValueString());
                }
            }
            mInputs.add((Object)input);
        }
        return form;
    }

    public static List<MForm> restoreForms(JSONArray forms) {
        ArrayList<MForm> mForms = new ArrayList<MForm>();
        for (int i = 0; i < forms.size(); ++i) {
            mForms.add(FormSerialization.restoreForm((JSONObject)forms.get(i)));
        }
        return mForms;
    }

    public static MForm restoreForm(JSONObject form) {
        JSONArray inputs = (JSONArray)form.get((Object)FORM_INPUTS);
        ArrayList mInputs = new ArrayList();
        for (int i = 0; i < inputs.size(); ++i) {
            JSONObject input = (JSONObject)inputs.get(i);
            MInputType type = MInputType.valueOf((String)input.get((Object)"type"));
            String name = (String)input.get((Object)"name");
            Boolean sensitive = (Boolean)input.get((Object)FORM_INPUT_SENSITIVE);
            MInput mInput = null;
            switch (type) {
                case STRING: {
                    long size = (Long)input.get((Object)FORM_INPUT_SIZE);
                    mInput = new MStringInput(name, sensitive, (short)size);
                    break;
                }
                case MAP: {
                    mInput = new MMapInput(name, sensitive);
                    break;
                }
                case INTEGER: {
                    mInput = new MIntegerInput(name, sensitive);
                    break;
                }
                case BOOLEAN: {
                    mInput = new MBooleanInput(name, sensitive);
                    break;
                }
                case ENUM: {
                    String values = (String)input.get((Object)FORM_INPUT_VALUES);
                    mInput = new MEnumInput(name, sensitive, values.split(","));
                    break;
                }
            }
            mInput.setPersistenceId((Long)input.get((Object)ID));
            if (input.containsKey((Object)FORM_INPUT_VALUE)) {
                switch (type) {
                    case MAP: {
                        try {
                            mInput.setValue((Map)input.get((Object)FORM_INPUT_VALUE));
                            break;
                        }
                        catch (ClassCastException e) {
                            throw new SqoopException((ErrorCode)SerializationError.SERIALIZATION_001, name + " requires a 'map' value.");
                        }
                    }
                    default: {
                        mInput.restoreFromUrlSafeValueString((String)input.get((Object)FORM_INPUT_VALUE));
                    }
                }
            }
            mInputs.add(mInput);
        }
        MForm mForm = new MForm((String)form.get((Object)"name"), mInputs);
        mForm.setPersistenceId((Long)form.get((Object)ID));
        return mForm;
    }

    private FormSerialization() {
    }
}

