/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.utils;

import junit.framework.TestCase;
import org.apache.sqoop.utils.ClassUtils;

public class TestClassUtils
extends TestCase {
    public void testLoadClass() {
        TestClassUtils.assertNull((Object)ClassUtils.loadClass((String)"A"));
        TestClassUtils.assertEquals(A.class, (Object)ClassUtils.loadClass((String)A.class.getName()));
    }

    public void testInstantiateNull() {
        TestClassUtils.assertNull((Object)ClassUtils.instantiate((Class)null, (Object[])new Object[0]));
    }

    public void testInstantiate() {
        A a = (A)ClassUtils.instantiate(A.class, (Object[])new Object[]{"a"});
        TestClassUtils.assertNotNull((Object)a);
        TestClassUtils.assertEquals((int)1, (int)a.num);
        TestClassUtils.assertEquals((String)"a", (String)a.a);
        A b = (A)ClassUtils.instantiate(A.class, (Object[])new Object[]{"b", 3, 5});
        TestClassUtils.assertNotNull((Object)b);
        TestClassUtils.assertEquals((int)3, (int)b.num);
        TestClassUtils.assertEquals((String)"b", (String)b.a);
        TestClassUtils.assertEquals((int)3, (int)b.b);
        TestClassUtils.assertEquals((int)5, (int)b.c);
    }

    public void testGetEnumStrings() {
        TestClassUtils.assertNull((Object)ClassUtils.getEnumStrings(A.class));
        this.assertEquals(new String[]{"A", "B", "C"}, ClassUtils.getEnumStrings(EnumA.class));
        this.assertEquals(new String[]{"X", "Y"}, ClassUtils.getEnumStrings(EnumX.class));
    }

    public void assertEquals(String[] expected, String[] actual) {
        TestClassUtils.assertEquals((String)"Arrays do not have same length", (int)expected.length, (int)actual.length);
        for (int i = 0; i < expected.length; ++i) {
            TestClassUtils.assertEquals((String)("Items on position " + i + " differs, expected " + expected[i] + ", actual " + actual[i]), (String)expected[i], (String)actual[i]);
        }
    }

    static enum EnumA {
        A,
        B,
        C;

    }

    static enum EnumX {
        X,
        Y;

    }

    public static class A {
        String a;
        int b;
        int c;
        int num = 1;

        public A(String a) {
            this.a = a;
        }

        public A(String a, Integer b, Integer c) {
            this(a);
            this.num = 3;
            this.b = b;
            this.c = c;
        }
    }
}

