/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.model;

import java.util.ArrayList;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.model.MForm;
import org.apache.sqoop.model.MIntegerInput;
import org.apache.sqoop.model.MJob;
import org.apache.sqoop.model.MJobForms;
import org.apache.sqoop.model.MMapInput;
import org.apache.sqoop.model.MStringInput;
import org.junit.Assert;
import org.junit.Test;

public class TestMJob {
    @Test
    public void testInitialization() {
        MJob job = this.job(MJob.Type.IMPORT);
        Assert.assertEquals((long)123L, (long)job.getConnectorId());
        Assert.assertEquals((Object)MJob.Type.IMPORT, (Object)job.getType());
        Assert.assertEquals((Object)"Buffy", (Object)job.getCreationUser());
        Assert.assertEquals((Object)"Vampire", (Object)job.getName());
        Assert.assertEquals((Object)this.forms1(MJob.Type.IMPORT), (Object)job.getConnectorPart());
        Assert.assertEquals((Object)this.forms2(MJob.Type.IMPORT), (Object)job.getFrameworkPart());
        MJob copy = new MJob(job);
        Assert.assertEquals((long)123L, (long)copy.getConnectorId());
        Assert.assertEquals((Object)MJob.Type.IMPORT, (Object)copy.getType());
        Assert.assertEquals((Object)"Vampire", (Object)copy.getName());
        Assert.assertEquals((Object)"Buffy", (Object)copy.getCreationUser());
        Assert.assertEquals((Object)job.getCreationDate(), (Object)copy.getCreationDate());
        Assert.assertEquals((Object)this.forms1(MJob.Type.IMPORT), (Object)copy.getConnectorPart());
        Assert.assertEquals((Object)this.forms2(MJob.Type.IMPORT), (Object)copy.getFrameworkPart());
        MJob upgradeCopy = new MJob(job, this.forms2(MJob.Type.IMPORT), this.forms1(MJob.Type.IMPORT));
        Assert.assertEquals((long)123L, (long)upgradeCopy.getConnectorId());
        Assert.assertEquals((Object)MJob.Type.IMPORT, (Object)upgradeCopy.getType());
        Assert.assertEquals((Object)"Vampire", (Object)upgradeCopy.getName());
        Assert.assertEquals((Object)"Buffy", (Object)upgradeCopy.getCreationUser());
        Assert.assertEquals((Object)job.getCreationDate(), (Object)upgradeCopy.getCreationDate());
        Assert.assertEquals((Object)this.forms2(MJob.Type.IMPORT), (Object)upgradeCopy.getConnectorPart());
        Assert.assertEquals((Object)this.forms1(MJob.Type.IMPORT), (Object)upgradeCopy.getFrameworkPart());
    }

    @Test(expected=SqoopException.class)
    public void testIncorrectDefaultConstructor() {
        new MJob(1L, 1L, MJob.Type.IMPORT, this.forms1(MJob.Type.IMPORT), this.forms2(MJob.Type.EXPORT));
    }

    @Test(expected=SqoopException.class)
    public void testIncorrectUpgradeConstructor() {
        new MJob(this.job(MJob.Type.EXPORT), this.forms1(MJob.Type.IMPORT), this.forms2(MJob.Type.IMPORT));
    }

    @Test
    public void testClone() {
        MJob job = this.job(MJob.Type.IMPORT);
        MJob withoutValue = job.clone(false);
        Assert.assertEquals((Object)job, (Object)withoutValue);
        Assert.assertEquals((long)-1L, (long)withoutValue.getPersistenceId());
        Assert.assertEquals((Object)MJob.Type.IMPORT, (Object)withoutValue.getType());
        Assert.assertNull((Object)withoutValue.getName());
        Assert.assertNull((Object)withoutValue.getCreationUser());
        Assert.assertEquals((Object)this.forms1(MJob.Type.IMPORT), (Object)withoutValue.getConnectorPart());
        Assert.assertEquals((Object)this.forms2(MJob.Type.IMPORT), (Object)withoutValue.getFrameworkPart());
        Assert.assertNull((Object)withoutValue.getConnectorPart().getForm("FORMNAME").getInput("INTEGER-INPUT").getValue());
        Assert.assertNull((Object)withoutValue.getConnectorPart().getForm("FORMNAME").getInput("STRING-INPUT").getValue());
        MJob withValue = job.clone(true);
        Assert.assertEquals((Object)job, (Object)withValue);
        Assert.assertEquals((long)job.getPersistenceId(), (long)withValue.getPersistenceId());
        Assert.assertEquals((Object)MJob.Type.IMPORT, (Object)withValue.getType());
        Assert.assertEquals((Object)job.getName(), (Object)withValue.getName());
        Assert.assertEquals((Object)job.getCreationUser(), (Object)withValue.getCreationUser());
        Assert.assertEquals((Object)this.forms1(MJob.Type.IMPORT), (Object)withValue.getConnectorPart());
        Assert.assertEquals((Object)this.forms2(MJob.Type.IMPORT), (Object)withValue.getFrameworkPart());
        Assert.assertEquals((Object)100, (Object)withValue.getConnectorPart().getForm("FORMNAME").getInput("INTEGER-INPUT").getValue());
        Assert.assertEquals((Object)"TEST-VALUE", (Object)withValue.getConnectorPart().getForm("FORMNAME").getInput("STRING-INPUT").getValue());
    }

    private MJob job(MJob.Type type) {
        MJob job = new MJob(123L, 456L, type, this.forms1(type), this.forms2(type));
        job.setName("Vampire");
        job.setCreationUser("Buffy");
        return job;
    }

    private MJobForms forms1(MJob.Type type) {
        ArrayList<MForm> forms = new ArrayList<MForm>();
        MIntegerInput input = new MIntegerInput("INTEGER-INPUT", false);
        input.setValue((Object)100);
        MStringInput strInput = new MStringInput("STRING-INPUT", false, 20);
        strInput.setValue((Object)"TEST-VALUE");
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(input);
        list.add(strInput);
        MForm form = new MForm("FORMNAME", list);
        forms.add(form);
        return new MJobForms(type, forms);
    }

    private MJobForms forms2(MJob.Type type) {
        ArrayList<MForm> forms = new ArrayList<MForm>();
        MMapInput input = new MMapInput("MAP-INPUT", false);
        ArrayList<MMapInput> list = new ArrayList<MMapInput>();
        list.add(input);
        MForm form = new MForm("form", list);
        forms.add(form);
        return new MJobForms(type, forms);
    }
}

