/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.model;

import java.util.ArrayList;
import org.apache.sqoop.model.MConnectionForms;
import org.apache.sqoop.model.MConnector;
import org.apache.sqoop.model.MForm;
import org.apache.sqoop.model.MInput;
import org.apache.sqoop.model.MIntegerInput;
import org.apache.sqoop.model.MJob;
import org.apache.sqoop.model.MJobForms;
import org.apache.sqoop.model.MStringInput;
import org.junit.Assert;
import org.junit.Test;

public class TestMConnector {
    @Test
    public void testInitialization() {
        ArrayList forms = new ArrayList();
        MConnectionForms connectionForms1 = new MConnectionForms(forms);
        MJobForms jobform1 = new MJobForms(MJob.Type.EXPORT, forms);
        ArrayList<MJobForms> jobFormList = new ArrayList<MJobForms>();
        jobFormList.add(jobform1);
        MConnector connector1 = new MConnector("NAME", "CLASSNAME", "1.0", connectionForms1, jobFormList);
        Assert.assertEquals((Object)"NAME", (Object)connector1.getUniqueName());
        Assert.assertEquals((Object)"CLASSNAME", (Object)connector1.getClassName());
        Assert.assertEquals((Object)"1.0", (Object)connector1.getVersion());
        MConnector connector2 = new MConnector("NAME", "CLASSNAME", "1.0", connectionForms1, jobFormList);
        Assert.assertEquals((Object)connector2, (Object)connector1);
        MConnector connector3 = new MConnector("NAME1", "CLASSNAME", "2.0", connectionForms1, jobFormList);
        Assert.assertFalse((boolean)connector1.equals((Object)connector3));
        try {
            connector1 = new MConnector(null, "CLASSNAME", "1.0", connectionForms1, jobFormList);
        }
        catch (NullPointerException e) {
            Assert.assertTrue((boolean)true);
        }
        try {
            connector1 = new MConnector("NAME", null, "1.0", connectionForms1, jobFormList);
        }
        catch (NullPointerException e) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testClone() {
        ArrayList<MForm> forms = new ArrayList<MForm>();
        MIntegerInput input = new MIntegerInput("INTEGER-INPUT", false);
        input.setValue((Object)100);
        MStringInput strInput = new MStringInput("STRING-INPUT", false, 20);
        strInput.setValue((Object)"TEST-VALUE");
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(input);
        list.add(strInput);
        MForm form = new MForm("FORMNAME", list);
        forms.add(form);
        MConnectionForms connectionForms1 = new MConnectionForms(forms);
        MJobForms jobform1 = new MJobForms(MJob.Type.EXPORT, forms);
        ArrayList<MJobForms> jobFormList = new ArrayList<MJobForms>();
        jobFormList.add(jobform1);
        MConnector connector1 = new MConnector("NAME", "CLASSNAME", "1.0", connectionForms1, jobFormList);
        Assert.assertEquals((Object)"NAME", (Object)connector1.getUniqueName());
        Assert.assertEquals((Object)"CLASSNAME", (Object)connector1.getClassName());
        Assert.assertEquals((Object)"1.0", (Object)connector1.getVersion());
        MConnector clone1 = connector1.clone(true);
        Assert.assertEquals((Object)"NAME", (Object)clone1.getUniqueName());
        Assert.assertEquals((Object)"CLASSNAME", (Object)clone1.getClassName());
        Assert.assertEquals((Object)"1.0", (Object)clone1.getVersion());
        MForm clonedForm1 = (MForm)clone1.getConnectionForms().getForms().get(0);
        Assert.assertNull((Object)((MInput)clonedForm1.getInputs().get(0)).getValue());
        Assert.assertNull((Object)((MInput)clonedForm1.getInputs().get(1)).getValue());
        MForm clonedForm2 = (MForm)clone1.getJobForms(MJob.Type.EXPORT).getForms().get(0);
        Assert.assertNull((Object)((MInput)clonedForm2.getInputs().get(0)).getValue());
        Assert.assertNull((Object)((MInput)clonedForm2.getInputs().get(1)).getValue());
        MConnector clone2 = connector1.clone(false);
        clonedForm1 = (MForm)clone2.getConnectionForms().getForms().get(0);
        Assert.assertNull((Object)((MInput)clonedForm1.getInputs().get(0)).getValue());
        Assert.assertNull((Object)((MInput)clonedForm1.getInputs().get(1)).getValue());
        clonedForm2 = (MForm)clone2.getJobForms(MJob.Type.EXPORT).getForms().get(0);
        Assert.assertNull((Object)((MInput)clonedForm2.getInputs().get(0)).getValue());
        Assert.assertNull((Object)((MInput)clonedForm2.getInputs().get(1)).getValue());
    }
}

