/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.model;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.model.ConfigurationClass;
import org.apache.sqoop.model.Form;
import org.apache.sqoop.model.FormClass;
import org.apache.sqoop.model.FormUtils;
import org.apache.sqoop.model.Input;
import org.apache.sqoop.model.MEnumInput;
import org.apache.sqoop.model.MForm;
import org.apache.sqoop.model.MInput;
import org.apache.sqoop.model.MIntegerInput;
import org.apache.sqoop.model.MMapInput;
import org.apache.sqoop.model.MStringInput;
import org.apache.sqoop.model.ModelError;
import org.apache.sqoop.validation.Status;
import org.apache.sqoop.validation.Validation;

public class TestFormUtils
extends TestCase {
    public void testToForms() {
        Config config = new Config();
        config.aForm.a1 = "value";
        List formsByInstance = FormUtils.toForms((Object)config);
        TestFormUtils.assertEquals(this.getForms(), (Object)formsByInstance);
        TestFormUtils.assertEquals((Object)"value", (Object)((MInput)((MForm)formsByInstance.get(0)).getInputs().get(0)).getValue());
        List formsByClass = FormUtils.toForms(Config.class);
        TestFormUtils.assertEquals(this.getForms(), (Object)formsByClass);
        List formsByBoth = FormUtils.toForms(Config.class, (Object)config);
        TestFormUtils.assertEquals(this.getForms(), (Object)formsByBoth);
        TestFormUtils.assertEquals((Object)"value", (Object)((MInput)((MForm)formsByBoth.get(0)).getInputs().get(0)).getValue());
    }

    public void testToFormsMissingAnnotation() {
        try {
            FormUtils.toForms(ConfigWithout.class);
        }
        catch (SqoopException ex) {
            TestFormUtils.assertEquals((Object)ModelError.MODEL_003, (Object)ex.getErrorCode());
            return;
        }
        TestFormUtils.fail((String)"Correct exception wasn't thrown");
    }

    public void testFailureOnPrimitiveType() {
        PrimitiveConfig config = new PrimitiveConfig();
        try {
            FormUtils.toForms((Object)config);
            TestFormUtils.fail((String)"We were expecting exception for unsupported type.");
        }
        catch (SqoopException ex) {
            TestFormUtils.assertEquals((Object)ModelError.MODEL_007, (Object)ex.getErrorCode());
        }
    }

    public void testFillValues() {
        List<MForm> forms = this.getForms();
        ((MStringInput)forms.get(0).getInputs().get(0)).setValue((Object)"value");
        Config config = new Config();
        FormUtils.fromForms(forms, (Object)config);
        TestFormUtils.assertEquals((String)"value", (String)config.aForm.a1);
    }

    public void testFillValuesObjectReuse() {
        List<MForm> forms = this.getForms();
        ((MStringInput)forms.get(0).getInputs().get(0)).setValue((Object)"value");
        Config config = new Config();
        config.aForm.a2 = "x";
        config.bForm.b1 = "y";
        FormUtils.fromForms(forms, (Object)config);
        TestFormUtils.assertEquals((String)"value", (String)config.aForm.a1);
        TestFormUtils.assertNull((Object)config.aForm.a2);
        TestFormUtils.assertNull((Object)config.bForm.b2);
        TestFormUtils.assertNull((Object)config.bForm.b2);
    }

    public void testApplyValidation() {
        Validation validation = this.getValidation();
        List<MForm> forms = this.getForms();
        FormUtils.applyValidation(forms, (Validation)validation);
        TestFormUtils.assertEquals((Object)Status.ACCEPTABLE, (Object)((MInput)forms.get(0).getInputs().get(0)).getValidationStatus());
        TestFormUtils.assertEquals((String)"e1", (String)((MInput)forms.get(0).getInputs().get(0)).getValidationMessage());
        TestFormUtils.assertEquals((Object)Status.UNACCEPTABLE, (Object)((MInput)forms.get(0).getInputs().get(1)).getValidationStatus());
        TestFormUtils.assertEquals((String)"e2", (String)((MInput)forms.get(0).getInputs().get(1)).getValidationMessage());
    }

    public void testJson() {
        Config config = new Config();
        config.aForm.a1 = "A";
        config.bForm.b2 = "B";
        config.cForm.intValue = 4;
        config.cForm.map.put("C", "D");
        config.cForm.enumeration = Enumeration.X;
        String json = FormUtils.toJson((Object)config);
        Config targetConfig = new Config();
        targetConfig.aForm.a2 = "X";
        targetConfig.bForm.b1 = "Y";
        targetConfig.cForm = null;
        FormUtils.fillValues((String)json, (Object)targetConfig);
        TestFormUtils.assertEquals((String)"A", (String)targetConfig.aForm.a1);
        TestFormUtils.assertNull((Object)targetConfig.aForm.a2);
        TestFormUtils.assertNull((Object)targetConfig.bForm.b1);
        TestFormUtils.assertEquals((String)"B", (String)targetConfig.bForm.b2);
        TestFormUtils.assertEquals((Object)4, (Object)targetConfig.cForm.intValue);
        TestFormUtils.assertEquals((int)1, (int)targetConfig.cForm.map.size());
        TestFormUtils.assertTrue((boolean)targetConfig.cForm.map.containsKey("C"));
        TestFormUtils.assertEquals((String)"D", (String)targetConfig.cForm.map.get("C"));
        TestFormUtils.assertEquals((Object)((Object)Enumeration.X), (Object)((Object)targetConfig.cForm.enumeration));
    }

    protected Validation getValidation() {
        HashMap<Validation.FormInput, Validation.Message> messages = new HashMap<Validation.FormInput, Validation.Message>();
        messages.put(new Validation.FormInput("aForm", "a1"), new Validation.Message(Status.ACCEPTABLE, "e1"));
        messages.put(new Validation.FormInput("aForm", "a2"), new Validation.Message(Status.UNACCEPTABLE, "e2"));
        return new Validation(Status.UNACCEPTABLE, messages);
    }

    protected List<MForm> getForms() {
        LinkedList<MForm> ret = new LinkedList<MForm>();
        LinkedList<Object> inputs = new LinkedList<Object>();
        inputs.add(new MStringInput("aForm.a1", false, 30));
        inputs.add(new MStringInput("aForm.a2", true, -1));
        ret.add(new MForm("aForm", inputs));
        inputs = new LinkedList();
        inputs.add(new MStringInput("bForm.b1", false, 2));
        inputs.add(new MStringInput("bForm.b2", false, 3));
        ret.add(new MForm("bForm", inputs));
        inputs = new LinkedList();
        inputs.add(new MIntegerInput("cForm.intValue", false));
        inputs.add(new MMapInput("cForm.map", false));
        inputs.add(new MEnumInput("cForm.enumeration", false, new String[]{"X", "Y"}));
        ret.add(new MForm("cForm", inputs));
        return ret;
    }

    static enum Enumeration {
        X,
        Y;

    }

    public static class ConfigWithout {
    }

    @FormClass
    public static class DForm {
        @Input
        int value;
    }

    @FormClass
    public static class CForm {
        @Input
        Integer intValue;
        @Input
        Map<String, String> map = new HashMap<String, String>();
        @Input
        Enumeration enumeration;
    }

    @FormClass
    public static class BForm {
        @Input(size=2)
        String b1;
        @Input(size=3)
        String b2;
    }

    @FormClass
    public static class AForm {
        @Input(size=30)
        String a1;
        @Input(sensitive=true)
        String a2;
    }

    @ConfigurationClass
    public static class PrimitiveConfig {
        @Form
        DForm dForm;
    }

    @ConfigurationClass
    public static class Config {
        @Form
        AForm aForm = new AForm();
        @Form
        BForm bForm = new BForm();
        @Form
        CForm cForm = new CForm();
    }
}

