/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.json;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import junit.framework.TestCase;
import org.apache.sqoop.json.SubmissionBean;
import org.apache.sqoop.model.MSubmission;
import org.apache.sqoop.schema.Schema;
import org.apache.sqoop.schema.type.Column;
import org.apache.sqoop.schema.type.Decimal;
import org.apache.sqoop.schema.type.Text;
import org.apache.sqoop.submission.SubmissionStatus;
import org.apache.sqoop.submission.counter.Counter;
import org.apache.sqoop.submission.counter.CounterGroup;
import org.apache.sqoop.submission.counter.Counters;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class TestSubmissionBean
extends TestCase {
    public void testTransferUnknown() {
        this.transfer(MSubmission.UNKNOWN);
        ArrayList<MSubmission> submissions = new ArrayList<MSubmission>();
        submissions.add(MSubmission.UNKNOWN);
        submissions.add(MSubmission.UNKNOWN);
        this.transfer(submissions);
    }

    public void testTransferJobId() {
        MSubmission source = new MSubmission();
        source.setJobId(666L);
        MSubmission target = this.transfer(source);
        TestSubmissionBean.assertEquals((long)666L, (long)target.getJobId());
        ArrayList<MSubmission> sources = new ArrayList<MSubmission>();
        MSubmission sourcex = new MSubmission();
        sourcex.setJobId(777L);
        sources.add(sourcex);
        MSubmission sourcey = new MSubmission();
        sourcey.setJobId(888L);
        sources.add(sourcey);
        List<MSubmission> targets = this.transfer(sources);
        TestSubmissionBean.assertNotNull((Object)targets.get(0));
        TestSubmissionBean.assertEquals((long)777L, (long)targets.get(0).getJobId());
        TestSubmissionBean.assertNotNull((Object)targets.get(1));
        TestSubmissionBean.assertEquals((long)888L, (long)targets.get(1).getJobId());
    }

    public void testTransferCreationUser() {
        String username = "admin";
        MSubmission source = new MSubmission();
        source.setCreationUser(username);
        MSubmission target = this.transfer(source);
        TestSubmissionBean.assertEquals((String)"admin", (String)target.getCreationUser());
        ArrayList<MSubmission> sources = new ArrayList<MSubmission>();
        MSubmission sourcex = new MSubmission();
        sourcex.setCreationUser("userA");
        sources.add(sourcex);
        MSubmission sourcey = new MSubmission();
        sourcey.setCreationUser("userB");
        sources.add(sourcey);
        List<MSubmission> targets = this.transfer(sources);
        TestSubmissionBean.assertNotNull((Object)targets.get(0));
        TestSubmissionBean.assertEquals((String)"userA", (String)targets.get(0).getCreationUser());
        TestSubmissionBean.assertNotNull((Object)targets.get(1));
        TestSubmissionBean.assertEquals((String)"userB", (String)targets.get(1).getCreationUser());
    }

    public void testTransferCreationDate() {
        Date date = new Date();
        MSubmission source = new MSubmission();
        source.setCreationDate(date);
        MSubmission target = this.transfer(source);
        TestSubmissionBean.assertEquals((Object)date, (Object)target.getCreationDate());
        ArrayList<MSubmission> sources = new ArrayList<MSubmission>();
        MSubmission sourcex = new MSubmission();
        Date datex = new Date(1000L);
        sourcex.setCreationDate(datex);
        sources.add(sourcex);
        Date datey = new Date(2000L);
        MSubmission sourcey = new MSubmission();
        sourcey.setCreationDate(datey);
        sources.add(sourcey);
        List<MSubmission> targets = this.transfer(sources);
        TestSubmissionBean.assertNotNull((Object)targets.get(0));
        TestSubmissionBean.assertEquals((Object)datex, (Object)targets.get(0).getCreationDate());
        TestSubmissionBean.assertNotNull((Object)targets.get(1));
        TestSubmissionBean.assertEquals((Object)datey, (Object)targets.get(1).getCreationDate());
    }

    public void testTransferLastUpdateUser() {
        String username = "admin";
        MSubmission source = new MSubmission();
        source.setLastUpdateUser(username);
        MSubmission target = this.transfer(source);
        TestSubmissionBean.assertEquals((String)"admin", (String)target.getLastUpdateUser());
        ArrayList<MSubmission> sources = new ArrayList<MSubmission>();
        MSubmission sourcex = new MSubmission();
        sourcex.setLastUpdateUser("userA");
        sources.add(sourcex);
        MSubmission sourcey = new MSubmission();
        sourcey.setLastUpdateUser("userB");
        sources.add(sourcey);
        List<MSubmission> targets = this.transfer(sources);
        TestSubmissionBean.assertNotNull((Object)targets.get(0));
        TestSubmissionBean.assertEquals((String)"userA", (String)targets.get(0).getLastUpdateUser());
        TestSubmissionBean.assertNotNull((Object)targets.get(1));
        TestSubmissionBean.assertEquals((String)"userB", (String)targets.get(1).getLastUpdateUser());
    }

    public void testTransferLastUpdateDate() {
        Date date = new Date();
        MSubmission source = new MSubmission();
        source.setLastUpdateDate(date);
        MSubmission target = this.transfer(source);
        TestSubmissionBean.assertEquals((Object)date, (Object)target.getLastUpdateDate());
        ArrayList<MSubmission> sources = new ArrayList<MSubmission>();
        MSubmission sourcex = new MSubmission();
        Date datex = new Date(1000L);
        sourcex.setLastUpdateDate(datex);
        sources.add(sourcex);
        Date datey = new Date(2000L);
        MSubmission sourcey = new MSubmission();
        sourcey.setLastUpdateDate(datey);
        sources.add(sourcey);
        List<MSubmission> targets = this.transfer(sources);
        TestSubmissionBean.assertNotNull((Object)targets.get(0));
        TestSubmissionBean.assertEquals((Object)datex, (Object)targets.get(0).getLastUpdateDate());
        TestSubmissionBean.assertNotNull((Object)targets.get(1));
        TestSubmissionBean.assertEquals((Object)datey, (Object)targets.get(1).getLastUpdateDate());
    }

    public void testTransferStatus() {
        MSubmission source = new MSubmission();
        source.setStatus(SubmissionStatus.SUCCEEDED);
        MSubmission target = this.transfer(source);
        TestSubmissionBean.assertEquals((Object)SubmissionStatus.SUCCEEDED, (Object)target.getStatus());
        ArrayList<MSubmission> sources = new ArrayList<MSubmission>();
        MSubmission sourcex = new MSubmission();
        sourcex.setStatus(SubmissionStatus.RUNNING);
        sources.add(sourcex);
        MSubmission sourcey = new MSubmission();
        sourcey.setStatus(SubmissionStatus.BOOTING);
        sources.add(sourcey);
        List<MSubmission> targets = this.transfer(sources);
        TestSubmissionBean.assertNotNull((Object)targets.get(0));
        TestSubmissionBean.assertEquals((Object)SubmissionStatus.RUNNING, (Object)targets.get(0).getStatus());
        TestSubmissionBean.assertNotNull((Object)targets.get(1));
        TestSubmissionBean.assertEquals((Object)SubmissionStatus.BOOTING, (Object)targets.get(1).getStatus());
    }

    public void testTransferExternalId() {
        MSubmission source = new MSubmission();
        source.setExternalId("Job-x");
        MSubmission target = this.transfer(source);
        TestSubmissionBean.assertEquals((String)"Job-x", (String)target.getExternalId());
        ArrayList<MSubmission> sources = new ArrayList<MSubmission>();
        MSubmission sourcex = new MSubmission();
        sourcex.setExternalId("Job-y");
        sources.add(sourcex);
        MSubmission sourcey = new MSubmission();
        sourcey.setExternalId("Job-z");
        sources.add(sourcey);
        List<MSubmission> targets = this.transfer(sources);
        TestSubmissionBean.assertNotNull((Object)targets.get(0));
        TestSubmissionBean.assertEquals((String)"Job-y", (String)targets.get(0).getExternalId());
        TestSubmissionBean.assertNotNull((Object)targets.get(1));
        TestSubmissionBean.assertEquals((String)"Job-z", (String)targets.get(1).getExternalId());
    }

    public void testTransferExternalLink() {
        MSubmission source = new MSubmission();
        source.setExternalLink("http://");
        MSubmission target = this.transfer(source);
        TestSubmissionBean.assertEquals((String)"http://", (String)target.getExternalLink());
        ArrayList<MSubmission> sources = new ArrayList<MSubmission>();
        MSubmission sourcex = new MSubmission();
        sourcex.setExternalLink("http://localhost:80");
        sources.add(sourcex);
        MSubmission sourcey = new MSubmission();
        sourcey.setExternalLink("http://localhost:8080");
        sources.add(sourcey);
        List<MSubmission> targets = this.transfer(sources);
        TestSubmissionBean.assertNotNull((Object)targets.get(0));
        TestSubmissionBean.assertEquals((String)"http://localhost:80", (String)targets.get(0).getExternalLink());
        TestSubmissionBean.assertNotNull((Object)targets.get(1));
        TestSubmissionBean.assertEquals((String)"http://localhost:8080", (String)targets.get(1).getExternalLink());
    }

    public void testTransferException() {
        MSubmission source = new MSubmission();
        source.setExceptionInfo("EndOfTheWorldException");
        MSubmission target = this.transfer(source);
        TestSubmissionBean.assertEquals((String)"EndOfTheWorldException", (String)target.getExceptionInfo());
        ArrayList<MSubmission> sources = new ArrayList<MSubmission>();
        MSubmission sourcex = new MSubmission();
        sourcex.setExceptionInfo("TheNewEraException");
        sources.add(sourcex);
        MSubmission sourcey = new MSubmission();
        sourcey.setExceptionInfo("EndOfTheWorldAgainException");
        sources.add(sourcey);
        List<MSubmission> targets = this.transfer(sources);
        TestSubmissionBean.assertNotNull((Object)targets.get(0));
        TestSubmissionBean.assertEquals((String)"TheNewEraException", (String)targets.get(0).getExceptionInfo());
        TestSubmissionBean.assertNotNull((Object)targets.get(1));
        TestSubmissionBean.assertEquals((String)"EndOfTheWorldAgainException", (String)targets.get(1).getExceptionInfo());
    }

    public void testTransferExceptionTrace() {
        MSubmission source = new MSubmission();
        source.setExceptionStackTrace("void.java(3): line infinity");
        MSubmission target = this.transfer(source);
        TestSubmissionBean.assertEquals((String)"void.java(3): line infinity", (String)target.getExceptionStackTrace());
        ArrayList<MSubmission> sources = new ArrayList<MSubmission>();
        MSubmission sourcex = new MSubmission();
        sourcex.setExceptionStackTrace("void.java(4): segment fault in Java");
        sources.add(sourcex);
        MSubmission sourcey = new MSubmission();
        sourcey.setExceptionStackTrace("void.java(5): core dumps in Java");
        sources.add(sourcey);
        List<MSubmission> targets = this.transfer(sources);
        TestSubmissionBean.assertNotNull((Object)targets.get(0));
        TestSubmissionBean.assertEquals((String)"void.java(4): segment fault in Java", (String)targets.get(0).getExceptionStackTrace());
        TestSubmissionBean.assertNotNull((Object)targets.get(1));
        TestSubmissionBean.assertEquals((String)"void.java(5): core dumps in Java", (String)targets.get(1).getExceptionStackTrace());
    }

    public void testTransferProgress() {
        MSubmission source = new MSubmission();
        source.setProgress(25.0);
        MSubmission target = this.transfer(source);
        TestSubmissionBean.assertEquals((Object)25.0, (Object)target.getProgress());
        ArrayList<MSubmission> sources = new ArrayList<MSubmission>();
        MSubmission sourcex = new MSubmission();
        sourcex.setProgress(50.0);
        sources.add(sourcex);
        MSubmission sourcey = new MSubmission();
        sourcey.setProgress(99.9);
        sources.add(sourcey);
        List<MSubmission> targets = this.transfer(sources);
        TestSubmissionBean.assertNotNull((Object)targets.get(0));
        TestSubmissionBean.assertEquals((Object)50.0, (Object)targets.get(0).getProgress());
        TestSubmissionBean.assertNotNull((Object)targets.get(1));
        TestSubmissionBean.assertEquals((Object)99.9, (Object)targets.get(1).getProgress());
    }

    public void testTransferCounters() {
        Counters counters = new Counters();
        counters.addCounterGroup(new CounterGroup("A").addCounter(new Counter("X", 1L)).addCounter(new Counter("Y", 2L)));
        counters.addCounterGroup(new CounterGroup("B").addCounter(new Counter("XX", 11L)).addCounter(new Counter("YY", 22L)));
        MSubmission source = new MSubmission();
        source.setCounters(counters);
        Counters target = this.transfer(source).getCounters();
        CounterGroup group = target.getCounterGroup("A");
        TestSubmissionBean.assertNotNull((Object)group);
        Counter counter = group.getCounter("X");
        TestSubmissionBean.assertNotNull((Object)counter);
        TestSubmissionBean.assertEquals((long)1L, (long)counter.getValue());
        counter = group.getCounter("Y");
        TestSubmissionBean.assertNotNull((Object)counter);
        TestSubmissionBean.assertEquals((long)2L, (long)counter.getValue());
        target = this.transfer(source).getCounters();
        group = target.getCounterGroup("B");
        TestSubmissionBean.assertNotNull((Object)group);
        counter = group.getCounter("XX");
        TestSubmissionBean.assertNotNull((Object)counter);
        TestSubmissionBean.assertEquals((long)11L, (long)counter.getValue());
        counter = group.getCounter("YY");
        TestSubmissionBean.assertNotNull((Object)counter);
        TestSubmissionBean.assertEquals((long)22L, (long)counter.getValue());
        Counters countersx = new Counters();
        countersx.addCounterGroup(new CounterGroup("C").addCounter(new Counter("XXX", 111L)).addCounter(new Counter("YYY", 222L)));
        countersx.addCounterGroup(new CounterGroup("D").addCounter(new Counter("XXXX", 1111L)).addCounter(new Counter("YYYY", 2222L)));
        Counters countersy = new Counters();
        countersy.addCounterGroup(new CounterGroup("E").addCounter(new Counter("XXXXX", 11111L)).addCounter(new Counter("YYYYY", 22222L)));
        countersy.addCounterGroup(new CounterGroup("F").addCounter(new Counter("XXXXXX", 111111L)).addCounter(new Counter("YYYYYY", 222222L)));
        ArrayList<MSubmission> sources = new ArrayList<MSubmission>();
        MSubmission sourcex = new MSubmission();
        sourcex.setCounters(countersx);
        sources.add(sourcex);
        MSubmission sourcey = new MSubmission();
        sourcey.setCounters(countersy);
        sources.add(sourcey);
        List<MSubmission> targets = this.transfer(sources);
        TestSubmissionBean.assertNotNull((Object)targets.get(0));
        target = targets.get(0).getCounters();
        group = target.getCounterGroup("C");
        TestSubmissionBean.assertNotNull((Object)group);
        counter = group.getCounter("XXX");
        TestSubmissionBean.assertNotNull((Object)counter);
        TestSubmissionBean.assertEquals((long)111L, (long)counter.getValue());
        counter = group.getCounter("YYY");
        TestSubmissionBean.assertNotNull((Object)counter);
        TestSubmissionBean.assertEquals((long)222L, (long)counter.getValue());
        group = target.getCounterGroup("D");
        TestSubmissionBean.assertNotNull((Object)group);
        counter = group.getCounter("XXXX");
        TestSubmissionBean.assertNotNull((Object)counter);
        TestSubmissionBean.assertEquals((long)1111L, (long)counter.getValue());
        counter = group.getCounter("YYYY");
        TestSubmissionBean.assertNotNull((Object)counter);
        TestSubmissionBean.assertEquals((long)2222L, (long)counter.getValue());
        TestSubmissionBean.assertNotNull((Object)targets.get(1));
        target = targets.get(1).getCounters();
        group = target.getCounterGroup("E");
        TestSubmissionBean.assertNotNull((Object)group);
        counter = group.getCounter("XXXXX");
        TestSubmissionBean.assertNotNull((Object)counter);
        TestSubmissionBean.assertEquals((long)11111L, (long)counter.getValue());
        counter = group.getCounter("YYYYY");
        TestSubmissionBean.assertNotNull((Object)counter);
        TestSubmissionBean.assertEquals((long)22222L, (long)counter.getValue());
        group = target.getCounterGroup("F");
        TestSubmissionBean.assertNotNull((Object)group);
        counter = group.getCounter("XXXXXX");
        TestSubmissionBean.assertNotNull((Object)counter);
        TestSubmissionBean.assertEquals((long)111111L, (long)counter.getValue());
        counter = group.getCounter("YYYYYY");
        TestSubmissionBean.assertNotNull((Object)counter);
        TestSubmissionBean.assertEquals((long)222222L, (long)counter.getValue());
    }

    public void testTransferConnectorSchema() {
        MSubmission source = new MSubmission();
        source.setConnectorSchema(this.getSchema());
        Schema target = this.transfer(source).getConnectorSchema();
        TestSubmissionBean.assertNotNull((Object)target);
        TestSubmissionBean.assertEquals((Object)this.getSchema(), (Object)target);
    }

    public void testTransferHioSchema() {
        MSubmission source = new MSubmission();
        source.setHioSchema(this.getSchema());
        Schema target = this.transfer(source).getHioSchema();
        TestSubmissionBean.assertNotNull((Object)target);
        TestSubmissionBean.assertEquals((Object)this.getSchema(), (Object)target);
    }

    private Schema getSchema() {
        return new Schema("schema").addColumn((Column)new Text("col1")).addColumn((Column)new Decimal("col2"));
    }

    private MSubmission transfer(MSubmission submission) {
        SubmissionBean bean = new SubmissionBean(submission);
        JSONObject json = bean.extract(false);
        String string = json.toString();
        JSONObject retrievedJson = (JSONObject)JSONValue.parse((String)string);
        SubmissionBean retrievedBean = new SubmissionBean();
        retrievedBean.restore(retrievedJson);
        return (MSubmission)retrievedBean.getSubmissions().get(0);
    }

    private List<MSubmission> transfer(List<MSubmission> submissions) {
        SubmissionBean bean = new SubmissionBean(submissions);
        JSONObject json = bean.extract(false);
        String string = json.toString();
        JSONObject retrievedJson = (JSONObject)JSONValue.parse((String)string);
        SubmissionBean retrievedBean = new SubmissionBean();
        retrievedBean.restore(retrievedJson);
        return retrievedBean.getSubmissions();
    }
}

