/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public final class ClassUtils {
    private static final Logger LOG = Logger.getLogger(ClassUtils.class);

    public static Class<?> loadClass(String className) {
        ClassLoader ctxLoader;
        if (className == null) {
            return null;
        }
        Class<?> klass = null;
        try {
            klass = Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            LOG.debug((Object)("Exception while loading class: " + className), (Throwable)ex);
        }
        if (klass == null && (ctxLoader = Thread.currentThread().getContextClassLoader()) != null) {
            try {
                klass = ctxLoader.loadClass(className);
            }
            catch (ClassNotFoundException ex) {
                LOG.debug((Object)("Exception while load class: " + className), (Throwable)ex);
            }
        }
        return klass;
    }

    public static Object instantiate(String className, Object ... args) {
        return ClassUtils.instantiate(ClassUtils.loadClass(className), args);
    }

    public static Object instantiate(Class klass, Object ... args) {
        if (klass == null) {
            return null;
        }
        Class[] argumentTypes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            Class<?> type;
            argumentTypes[i] = type = args[i].getClass();
        }
        try {
            Constructor constructor = klass.getConstructor(argumentTypes);
            return constructor.newInstance(args);
        }
        catch (NoSuchMethodException e) {
            LOG.debug((Object)"Can't find such constructor.", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            LOG.debug((Object)"Can't instantiate object.", (Throwable)e);
        }
        catch (InstantiationException e) {
            LOG.debug((Object)"Can't instantiate object.", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOG.debug((Object)"Can't instantiate object.", (Throwable)e);
        }
        return null;
    }

    public static String jarForClass(String className) {
        Class<?> klass = ClassUtils.loadClass(className);
        return ClassUtils.jarForClass(klass);
    }

    public static String jarForClass(Class klass) {
        return klass.getProtectionDomain().getCodeSource().getLocation().toString();
    }

    public static String[] getEnumStrings(Class klass) {
        if (!klass.isEnum()) {
            return null;
        }
        ArrayList<String> values = new ArrayList<String>();
        try {
            Method methodName = klass.getMethod("name", new Class[0]);
            for (Object constant : klass.getEnumConstants()) {
                values.add((String)methodName.invoke(constant, new Object[0]));
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Can't get list of values from enumeration " + klass.getCanonicalName()), (Throwable)e);
            return null;
        }
        return values.toArray(new String[values.size()]);
    }

    private ClassUtils() {
    }
}

