/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.model;

import org.apache.sqoop.model.MAccountableEntity;
import org.apache.sqoop.model.MClonable;
import org.apache.sqoop.model.MConnectionForms;
import org.apache.sqoop.model.MForm;

public class MConnection
extends MAccountableEntity
implements MClonable {
    private long connectorId;
    private String name;
    private final MConnectionForms connectorPart;
    private final MConnectionForms frameworkPart;

    public MConnection(long connectorId, MConnectionForms connectorPart, MConnectionForms frameworkPart) {
        this.connectorId = connectorId;
        this.connectorPart = connectorPart;
        this.frameworkPart = frameworkPart;
    }

    public MConnection(MConnection other) {
        this(other, other.connectorPart.clone(true), other.frameworkPart.clone(true));
    }

    public MConnection(MConnection other, MConnectionForms connectorPart, MConnectionForms frameworkPart) {
        super(other);
        this.connectorId = other.connectorId;
        this.name = other.name;
        this.connectorPart = connectorPart;
        this.frameworkPart = frameworkPart;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("connection: ").append(this.name);
        sb.append(" connector-part: ").append(this.connectorPart);
        sb.append(", framework-part: ").append(this.frameworkPart);
        return sb.toString();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getConnectorId() {
        return this.connectorId;
    }

    public void setConnectorId(long connectorId) {
        this.connectorId = connectorId;
    }

    public MConnectionForms getConnectorPart() {
        return this.connectorPart;
    }

    public MConnectionForms getFrameworkPart() {
        return this.frameworkPart;
    }

    public MForm getConnectorForm(String formName) {
        return this.connectorPart.getForm(formName);
    }

    public MForm getFrameworkForm(String formName) {
        return this.frameworkPart.getForm(formName);
    }

    @Override
    public MConnection clone(boolean cloneWithValue) {
        if (cloneWithValue) {
            return new MConnection(this);
        }
        return new MConnection(this.connectorId, this.connectorPart.clone(false), this.frameworkPart.clone(false));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MConnection)) {
            return false;
        }
        MConnection mc = (MConnection)object;
        return mc.connectorId == this.connectorId && mc.getPersistenceId() == this.getPersistenceId() && mc.connectorPart.equals(this.connectorPart) && mc.frameworkPart.equals(this.frameworkPart);
    }
}

