/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.json.util;

import org.apache.sqoop.schema.Schema;
import org.apache.sqoop.schema.type.AbstractComplexType;
import org.apache.sqoop.schema.type.AbstractString;
import org.apache.sqoop.schema.type.Array;
import org.apache.sqoop.schema.type.Binary;
import org.apache.sqoop.schema.type.Bit;
import org.apache.sqoop.schema.type.Column;
import org.apache.sqoop.schema.type.Date;
import org.apache.sqoop.schema.type.DateTime;
import org.apache.sqoop.schema.type.Decimal;
import org.apache.sqoop.schema.type.Enum;
import org.apache.sqoop.schema.type.FixedPoint;
import org.apache.sqoop.schema.type.FloatingPoint;
import org.apache.sqoop.schema.type.Map;
import org.apache.sqoop.schema.type.Set;
import org.apache.sqoop.schema.type.Text;
import org.apache.sqoop.schema.type.Time;
import org.apache.sqoop.schema.type.Type;
import org.apache.sqoop.schema.type.Unsupported;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class SchemaSerialization {
    private static final String NAME = "name";
    private static final String CREATION_DATE = "created";
    private static final String NOTE = "note";
    private static final String COLUMNS = "columns";
    private static final String TYPE = "type";
    private static final String NULLABLE = "nullable";
    private static final String KEY = "key";
    private static final String VALUE = "value";
    private static final String SIZE = "size";
    private static final String FRACTION = "fraction";
    private static final String TIMEZONE = "timezone";
    private static final String PRECISION = "precision";
    private static final String SCALE = "scale";
    private static final String UNSIGNED = "unsigned";
    private static final String JDBC_TYPE = "jdbc-type";

    public static JSONObject extractSchema(Schema schema) {
        JSONObject object = new JSONObject();
        object.put((Object)NAME, (Object)schema.getName());
        object.put((Object)CREATION_DATE, (Object)schema.getCreationDate().getTime());
        if (schema.getNote() != null) {
            object.put((Object)NOTE, (Object)schema.getNote());
        }
        JSONArray columnArray = new JSONArray();
        for (Column column : schema.getColumns()) {
            columnArray.add((Object)SchemaSerialization.extractColumn(column));
        }
        object.put((Object)COLUMNS, (Object)columnArray);
        return object;
    }

    public static Schema restoreSchemna(JSONObject jsonObject) {
        String name = (String)jsonObject.get((Object)NAME);
        String note = (String)jsonObject.get((Object)NOTE);
        java.util.Date date = new java.util.Date((Long)jsonObject.get((Object)CREATION_DATE));
        Schema schema = new Schema(name).setNote(note).setCreationDate(date);
        JSONArray columnsArray = (JSONArray)jsonObject.get((Object)COLUMNS);
        for (Object obj : columnsArray) {
            schema.addColumn(SchemaSerialization.restoreColumn((JSONObject)obj));
        }
        return schema;
    }

    private static JSONObject extractColumn(Column column) {
        JSONObject ret = new JSONObject();
        ret.put((Object)NAME, (Object)column.getName());
        ret.put((Object)NULLABLE, (Object)column.getNullable());
        ret.put((Object)TYPE, (Object)column.getType().name());
        switch (column.getType()) {
            case MAP: {
                ret.put((Object)VALUE, (Object)SchemaSerialization.extractColumn(((Map)column).getValue()));
            }
            case ARRAY: 
            case ENUM: 
            case SET: {
                ret.put((Object)KEY, (Object)SchemaSerialization.extractColumn(((AbstractComplexType)column).getKey()));
                break;
            }
            case BINARY: 
            case TEXT: {
                ret.put((Object)SIZE, (Object)((AbstractString)column).getSize());
                break;
            }
            case DATE_TIME: {
                ret.put((Object)FRACTION, (Object)((DateTime)column).getFraction());
                ret.put((Object)TIMEZONE, (Object)((DateTime)column).getTimezone());
                break;
            }
            case DECIMAL: {
                ret.put((Object)PRECISION, (Object)((Decimal)column).getPrecision());
                ret.put((Object)SCALE, (Object)((Decimal)column).getScale());
                break;
            }
            case FIXED_POINT: {
                ret.put((Object)SIZE, (Object)((FixedPoint)column).getByteSize());
                ret.put((Object)UNSIGNED, (Object)((FixedPoint)column).getUnsigned());
                break;
            }
            case FLOATING_POINT: {
                ret.put((Object)SIZE, (Object)((FloatingPoint)column).getByteSize());
                break;
            }
            case TIME: {
                ret.put((Object)FRACTION, (Object)((Time)column).getFraction());
                break;
            }
            case UNSUPPORTED: {
                ret.put((Object)JDBC_TYPE, (Object)((Unsupported)column).getJdbcType());
                break;
            }
            case DATE: 
            case BIT: {
                break;
            }
        }
        return ret;
    }

    private static Column restoreColumn(JSONObject obj) {
        String name = (String)obj.get((Object)NAME);
        Boolean nullable = (Boolean)obj.get((Object)NULLABLE);
        Column key = null;
        if (obj.containsKey((Object)KEY)) {
            key = SchemaSerialization.restoreColumn((JSONObject)obj.get((Object)KEY));
        }
        Column value = null;
        if (obj.containsKey((Object)VALUE)) {
            value = SchemaSerialization.restoreColumn((JSONObject)obj.get((Object)VALUE));
        }
        Long size = (Long)obj.get((Object)SIZE);
        Boolean fraction = (Boolean)obj.get((Object)FRACTION);
        Boolean timezone = (Boolean)obj.get((Object)TIMEZONE);
        Long precision = (Long)obj.get((Object)PRECISION);
        Long scale = (Long)obj.get((Object)SCALE);
        Boolean unsigned = (Boolean)obj.get((Object)UNSIGNED);
        Long jdbcType = (Long)obj.get((Object)JDBC_TYPE);
        Type type = Type.valueOf((String)obj.get((Object)TYPE));
        Column output = null;
        switch (type) {
            case ARRAY: {
                output = new Array(key);
                break;
            }
            case BINARY: {
                output = new Binary().setSize(size);
                break;
            }
            case BIT: {
                output = new Bit();
                break;
            }
            case DATE: {
                output = new Date();
                break;
            }
            case DATE_TIME: {
                output = new DateTime().setFraction(fraction).setTimezone(timezone);
                break;
            }
            case DECIMAL: {
                output = new Decimal().setPrecision(precision).setScale(scale);
                break;
            }
            case ENUM: {
                output = new Enum(key);
                break;
            }
            case FIXED_POINT: {
                output = new FixedPoint().setByteSize(size).setUnsigned(unsigned);
                break;
            }
            case FLOATING_POINT: {
                output = new FloatingPoint().setByteSize(size);
                break;
            }
            case MAP: {
                output = new Map(key, value);
                break;
            }
            case SET: {
                output = new Set(key);
                break;
            }
            case TEXT: {
                output = new Text().setSize(size);
                break;
            }
            case TIME: {
                output = new Time().setFraction(fraction);
                break;
            }
            case UNSUPPORTED: {
                output = new Unsupported().setJdbcType(jdbcType);
                break;
            }
        }
        output.setName(name);
        output.setNullable(nullable);
        return output;
    }

    private SchemaSerialization() {
    }
}

