/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.json;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.sqoop.json.JsonBean;
import org.apache.sqoop.json.util.FormSerialization;
import org.apache.sqoop.json.util.ResourceBundleSerialization;
import org.apache.sqoop.model.MConnectionForms;
import org.apache.sqoop.model.MForm;
import org.apache.sqoop.model.MFramework;
import org.apache.sqoop.model.MJob;
import org.apache.sqoop.model.MJobForms;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class FrameworkBean
implements JsonBean {
    private MFramework framework;
    private ResourceBundle bundle;

    public FrameworkBean(MFramework framework, ResourceBundle bundle) {
        this.framework = framework;
        this.bundle = bundle;
    }

    public FrameworkBean() {
    }

    public MFramework getFramework() {
        return this.framework;
    }

    public ResourceBundle getResourceBundle() {
        return this.bundle;
    }

    @Override
    public JSONObject extract(boolean skipSensitive) {
        JSONArray conForms = FormSerialization.extractForms(this.framework.getConnectionForms().getForms(), skipSensitive);
        JSONObject jobForms = new JSONObject();
        for (MJobForms job : this.framework.getAllJobsForms().values()) {
            jobForms.put((Object)job.getType().name(), (Object)FormSerialization.extractForms(job.getForms(), skipSensitive));
        }
        JSONObject result = new JSONObject();
        result.put((Object)"id", (Object)this.framework.getPersistenceId());
        result.put((Object)"framework-version", (Object)this.framework.getVersion());
        result.put((Object)"con-forms", (Object)conForms);
        result.put((Object)"job-forms", (Object)jobForms);
        result.put((Object)"resources", (Object)ResourceBundleSerialization.extractResourceBundle(this.bundle));
        return result;
    }

    @Override
    public void restore(JSONObject jsonObject) {
        long id = (Long)jsonObject.get((Object)"id");
        String frameworkVersion = (String)jsonObject.get((Object)"framework-version");
        List<MForm> connForms = FormSerialization.restoreForms((JSONArray)jsonObject.get((Object)"con-forms"));
        JSONObject jobForms = (JSONObject)jsonObject.get((Object)"job-forms");
        ArrayList<MJobForms> jobs = new ArrayList<MJobForms>();
        for (Map.Entry entry : jobForms.entrySet()) {
            MJob.Type type = MJob.Type.valueOf((String)entry.getKey());
            List<MForm> job = FormSerialization.restoreForms((JSONArray)entry.getValue());
            jobs.add(new MJobForms(type, job));
        }
        this.framework = new MFramework(new MConnectionForms(connForms), jobs, frameworkVersion);
        this.framework.setPersistenceId(id);
        this.bundle = ResourceBundleSerialization.restoreResourceBundle((JSONObject)jsonObject.get((Object)"resources"));
    }
}

