/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.json;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.sqoop.json.JsonBean;
import org.apache.sqoop.json.util.FormSerialization;
import org.apache.sqoop.json.util.ResourceBundleSerialization;
import org.apache.sqoop.model.MConnectionForms;
import org.apache.sqoop.model.MConnector;
import org.apache.sqoop.model.MForm;
import org.apache.sqoop.model.MJob;
import org.apache.sqoop.model.MJobForms;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class ConnectorBean
implements JsonBean {
    private List<MConnector> connectors;
    private Map<Long, ResourceBundle> bundles;

    public ConnectorBean(List<MConnector> connectors, Map<Long, ResourceBundle> bundles) {
        this.connectors = connectors;
        this.bundles = bundles;
    }

    public ConnectorBean() {
    }

    public List<MConnector> getConnectors() {
        return this.connectors;
    }

    public Map<Long, ResourceBundle> getResourceBundles() {
        return this.bundles;
    }

    @Override
    public JSONObject extract(boolean skipSensitive) {
        JSONArray array = new JSONArray();
        for (MConnector connector : this.connectors) {
            JSONObject object = new JSONObject();
            object.put((Object)"id", (Object)connector.getPersistenceId());
            object.put((Object)"name", (Object)connector.getUniqueName());
            object.put((Object)"class", (Object)connector.getClassName());
            object.put((Object)"version", (Object)connector.getVersion());
            object.put((Object)"con-forms", (Object)FormSerialization.extractForms(connector.getConnectionForms().getForms(), skipSensitive));
            JSONObject jobForms = new JSONObject();
            for (MJobForms job : connector.getAllJobsForms().values()) {
                jobForms.put((Object)job.getType().name(), (Object)FormSerialization.extractForms(job.getForms(), skipSensitive));
            }
            object.put((Object)"job-forms", (Object)jobForms);
            array.add((Object)object);
        }
        JSONObject all = new JSONObject();
        all.put((Object)"all", (Object)array);
        if (this.bundles != null && !this.bundles.isEmpty()) {
            JSONObject jsonBundles = new JSONObject();
            for (Map.Entry<Long, ResourceBundle> entry : this.bundles.entrySet()) {
                jsonBundles.put((Object)entry.getKey().toString(), (Object)ResourceBundleSerialization.extractResourceBundle(entry.getValue()));
            }
            all.put((Object)"resources-connector", (Object)jsonBundles);
        }
        return all;
    }

    @Override
    public void restore(JSONObject jsonObject) {
        this.connectors = new ArrayList<MConnector>();
        JSONArray array = (JSONArray)jsonObject.get((Object)"all");
        for (Object obj : array) {
            JSONObject object = (JSONObject)obj;
            long connectorId = (Long)object.get((Object)"id");
            String uniqueName = (String)object.get((Object)"name");
            String className = (String)object.get((Object)"class");
            String version = (String)object.get((Object)"version");
            List<MForm> connForms = FormSerialization.restoreForms((JSONArray)object.get((Object)"con-forms"));
            JSONObject jobJson = (JSONObject)object.get((Object)"job-forms");
            ArrayList<MJobForms> jobs = new ArrayList<MJobForms>();
            for (Map.Entry entry : jobJson.entrySet()) {
                MJob.Type type = MJob.Type.valueOf((String)entry.getKey());
                List<MForm> jobForms = FormSerialization.restoreForms((JSONArray)jobJson.get(entry.getKey()));
                jobs.add(new MJobForms(type, jobForms));
            }
            MConnector connector = new MConnector(uniqueName, className, version, new MConnectionForms(connForms), jobs);
            connector.setPersistenceId(connectorId);
            this.connectors.add(connector);
        }
        if (jsonObject.containsKey((Object)"resources-connector")) {
            this.bundles = new HashMap<Long, ResourceBundle>();
            JSONObject jsonBundles = (JSONObject)jsonObject.get((Object)"resources-connector");
            Set entrySet = jsonBundles.entrySet();
            for (Map.Entry entry : entrySet) {
                this.bundles.put(Long.parseLong((String)entry.getKey()), ResourceBundleSerialization.restoreResourceBundle((JSONObject)entry.getValue()));
            }
        }
    }
}

