/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.validation;

import java.util.HashMap;
import junit.framework.TestCase;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.validation.Status;
import org.apache.sqoop.validation.Validation;
import org.apache.sqoop.validation.ValidationError;

public class TestValidation
extends TestCase {
    public void testInitialization() {
        Validation validation = new Validation(Class.class);
        TestValidation.assertNotNull((Object)validation);
        TestValidation.assertEquals((Object)Status.FINE, (Object)validation.getStatus());
        TestValidation.assertEquals((int)0, (int)validation.getMessages().size());
        Validation validationNull = new Validation(null, null);
        TestValidation.assertNotNull((Object)validationNull);
        TestValidation.assertNull((Object)validationNull.getStatus());
        TestValidation.assertNull((Object)validationNull.getMessages());
        Status s1 = Status.FINE;
        HashMap msg1 = new HashMap();
        Validation validation1 = new Validation(s1, msg1);
        TestValidation.assertNotNull((Object)validation1);
        TestValidation.assertEquals((Object)Status.FINE, (Object)validation1.getStatus());
        TestValidation.assertEquals((int)0, (int)validation1.getMessages().size());
        Status s2 = Status.ACCEPTABLE;
        HashMap msg2 = new HashMap();
        Validation validation2 = new Validation(s2, msg2);
        TestValidation.assertNotNull((Object)validation2);
        TestValidation.assertEquals((Object)Status.ACCEPTABLE, (Object)validation2.getStatus());
        TestValidation.assertEquals((int)0, (int)validation2.getMessages().size());
        Status s3 = Status.ACCEPTABLE;
        HashMap<Validation.FormInput, Validation.Message> msg3 = new HashMap<Validation.FormInput, Validation.Message>();
        Validation.FormInput fi = new Validation.FormInput("form\\.input");
        Validation.Message message = new Validation.Message(Status.FINE, "sqoop");
        msg3.put(fi, message);
        Validation validation3 = new Validation(s3, msg3);
        Validation.FormInput fiTest = new Validation.FormInput("form\\.input");
        Validation.Message messageTest = new Validation.Message(Status.FINE, "sqoop");
        TestValidation.assertEquals((Object)messageTest, validation3.getMessages().get(fiTest));
        TestValidation.assertEquals((Object)Status.ACCEPTABLE, (Object)validation3.getStatus());
    }

    public void testFormInput() {
        Validation.FormInput fi = new Validation.FormInput("test\\.test");
        TestValidation.assertNotNull((Object)fi);
        try {
            new Validation.FormInput(null);
            TestValidation.fail((String)"Assert error is expected");
        }
        catch (AssertionError e) {
            TestValidation.assertTrue((boolean)true);
        }
        try {
            new Validation.FormInput("");
            TestValidation.fail((String)"SqoopException is expected");
        }
        catch (SqoopException e) {
            TestValidation.assertEquals((String)ValidationError.VALIDATION_0003.getMessage(), (String)e.getErrorCode().getMessage());
        }
        Validation.FormInput fi2 = new Validation.FormInput("form\\.input");
        TestValidation.assertEquals((String)"form\\", (String)fi2.getForm());
        TestValidation.assertEquals((String)"input", (String)fi2.getInput());
        Validation.FormInput fiOne = new Validation.FormInput("form\\.input");
        Validation.FormInput fiTwo = new Validation.FormInput("form\\.input");
        TestValidation.assertEquals((Object)fiOne, (Object)fiTwo);
        TestValidation.assertEquals((String)"form\\.input", (String)fiOne.toString());
        Validation.FormInput fi3 = new Validation.FormInput("form");
        TestValidation.assertEquals((String)"form", (String)fi3.getForm());
        TestValidation.assertNull((Object)fi3.getInput());
        TestValidation.assertEquals((String)"form", (String)fi3.toString());
    }

    public void testMessage() {
        Validation.Message msg1 = new Validation.Message(null, null);
        TestValidation.assertNull((Object)msg1.getStatus());
        TestValidation.assertNull((Object)msg1.getMessage());
        Validation.Message msg2 = new Validation.Message(Status.FINE, "sqoop");
        TestValidation.assertEquals((Object)Status.FINE, (Object)msg2.getStatus());
        TestValidation.assertEquals((String)"sqoop", (String)msg2.getMessage());
        Validation.Message msg3 = new Validation.Message(Status.FINE, "sqoop");
        TestValidation.assertEquals((Object)msg2, (Object)msg3);
    }
}

