/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.model;

import org.apache.sqoop.model.MInputType;
import org.apache.sqoop.model.MIntegerInput;
import org.apache.sqoop.model.MStringInput;
import org.junit.Assert;
import org.junit.Test;

public class TestMIntegerInput {
    @Test
    public void testInitialization() {
        MIntegerInput input = new MIntegerInput("sqoopsqoop", false);
        Assert.assertEquals((Object)"sqoopsqoop", (Object)input.getName());
        Assert.assertEquals((Object)MInputType.INTEGER, (Object)input.getType());
    }

    @Test
    public void testEquals() {
        MIntegerInput input1 = new MIntegerInput("sqoopsqoop", false);
        MIntegerInput input2 = new MIntegerInput("sqoopsqoop", false);
        Assert.assertTrue((boolean)input1.equals((Object)input2));
        MIntegerInput input3 = new MIntegerInput("sqoopsqoop", false);
        MIntegerInput input4 = new MIntegerInput("sqoopsqoop1", false);
        Assert.assertFalse((boolean)input3.equals((Object)input4));
    }

    @Test
    public void testValue() {
        MIntegerInput input1 = new MIntegerInput("sqoopsqoop", false);
        input1.setValue((Object)99);
        Assert.assertEquals((Object)new Integer(99), (Object)input1.getValue());
        input1.setEmpty();
        Assert.assertNull((Object)input1.getValue());
    }

    @Test
    public void testUrlSafe() {
        MIntegerInput input1 = new MIntegerInput("sqoopsqoop", false);
        input1.setValue((Object)1001);
        String tmp = input1.getUrlSafeValueString();
        input1.restoreFromUrlSafeValueString(tmp);
        Assert.assertEquals((Object)new Integer(1001), (Object)input1.getValue());
    }

    @Test
    public void testNamedElement() {
        MStringInput input1 = new MStringInput("sqoopsqoop", true, 5);
        Assert.assertEquals((Object)"sqoopsqoop.label", (Object)input1.getLabelKey());
        Assert.assertEquals((Object)"sqoopsqoop.help", (Object)input1.getHelpKey());
    }

    @Test
    public void testSensitivity() {
        MIntegerInput input1 = new MIntegerInput("NAME", false);
        MIntegerInput input2 = new MIntegerInput("NAME", true);
        Assert.assertFalse((boolean)input1.isSensitive());
        Assert.assertTrue((boolean)input2.isSensitive());
    }
}

