/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.json.util;

import org.apache.sqoop.json.util.SchemaSerialization;
import org.apache.sqoop.schema.Schema;
import org.apache.sqoop.schema.type.Array;
import org.apache.sqoop.schema.type.Binary;
import org.apache.sqoop.schema.type.Bit;
import org.apache.sqoop.schema.type.Column;
import org.apache.sqoop.schema.type.Date;
import org.apache.sqoop.schema.type.DateTime;
import org.apache.sqoop.schema.type.Decimal;
import org.apache.sqoop.schema.type.Enum;
import org.apache.sqoop.schema.type.FixedPoint;
import org.apache.sqoop.schema.type.FloatingPoint;
import org.apache.sqoop.schema.type.Map;
import org.apache.sqoop.schema.type.Set;
import org.apache.sqoop.schema.type.Text;
import org.apache.sqoop.schema.type.Time;
import org.apache.sqoop.schema.type.Unsupported;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.junit.Assert;
import org.junit.Test;

public class TestSchemaSerialization {
    @Test
    public void testArray() {
        Schema array = new Schema("array").addColumn((Column)new Array("a", (Column)new Decimal()));
        this.transferAndAssert(array);
    }

    @Test
    public void testBinary() {
        Schema binary = new Schema("b").addColumn((Column)new Binary("A", Long.valueOf(100L)));
        this.transferAndAssert(binary);
    }

    @Test
    public void testBit() {
        Schema bit = new Schema("b").addColumn((Column)new Bit("B"));
        this.transferAndAssert(bit);
    }

    @Test
    public void testDate() {
        Schema date = new Schema("d").addColumn((Column)new Date("d"));
        this.transferAndAssert(date);
    }

    @Test
    public void testDateTime() {
        Schema dateTime = new Schema("dt").addColumn((Column)new DateTime("dt", Boolean.FALSE, Boolean.TRUE));
        this.transferAndAssert(dateTime);
    }

    @Test
    public void testDecimal() {
        Schema decimal = new Schema("d").addColumn((Column)new Decimal("d", Long.valueOf(12L), Long.valueOf(15L)));
        this.transferAndAssert(decimal);
    }

    @Test
    public void testEnum() {
        Schema e = new Schema("e").addColumn((Column)new Enum("e", (Column)new Text()));
        this.transferAndAssert(e);
    }

    @Test
    public void testFixedPoint() {
        Schema f = new Schema("f").addColumn((Column)new FixedPoint("fp", Long.valueOf(4L), Boolean.FALSE));
        this.transferAndAssert(f);
    }

    @Test
    public void testFloatingPoint() {
        Schema fp = new Schema("fp").addColumn((Column)new FloatingPoint("k", Long.valueOf(4L)));
        this.transferAndAssert(fp);
    }

    @Test
    public void testMap() {
        Schema m = new Schema("m").addColumn((Column)new Map("m", (Column)new Text(), (Column)new Decimal()));
        this.transferAndAssert(m);
    }

    @Test
    public void testSet() {
        Schema s = new Schema("s").addColumn((Column)new Set("b", (Column)new Binary()));
        this.transferAndAssert(s);
    }

    @Test
    public void testText() {
        Schema t = new Schema("t").addColumn((Column)new Text("x", Long.valueOf(10L)));
        this.transferAndAssert(t);
    }

    @Test
    public void testTime() {
        Schema t = new Schema("t").addColumn((Column)new Time("t", Boolean.FALSE));
        this.transferAndAssert(t);
    }

    @Test
    public void testUnsupported() {
        Schema t = new Schema("t").addColumn((Column)new Unsupported("u", Long.valueOf(4L)));
        this.transferAndAssert(t);
    }

    @Test
    public void testNullable() {
        Schema nullable = new Schema("n").addColumn((Column)new Text("x", Boolean.FALSE));
        this.transferAndAssert(nullable);
    }

    @Test
    public void testAllTypes() {
        Schema allTypes = new Schema("all-types").addColumn((Column)new Array("a", (Column)new Text())).addColumn((Column)new Binary("b")).addColumn((Column)new Bit("c")).addColumn((Column)new Date("d")).addColumn((Column)new DateTime("e")).addColumn((Column)new Decimal("f")).addColumn((Column)new Enum("g", (Column)new Text())).addColumn((Column)new FixedPoint("h")).addColumn((Column)new FloatingPoint("i")).addColumn((Column)new Map("j", (Column)new Text(), (Column)new Text())).addColumn((Column)new Set("k", (Column)new Text())).addColumn((Column)new Text("l")).addColumn((Column)new Time("m")).addColumn((Column)new Unsupported("u"));
        this.transferAndAssert(allTypes);
    }

    @Test
    public void testComplex() {
        Schema complex = new Schema("complex").addColumn(new Map((Column)new Array((Column)new Enum((Column)new Text())), (Column)new Set((Column)new Array((Column)new Text()))).setName("a"));
        this.transferAndAssert(complex);
    }

    private void transferAndAssert(Schema schema) {
        Schema transferred = this.transfer(schema);
        Assert.assertEquals((Object)schema, (Object)transferred);
    }

    protected Schema transfer(Schema schema) {
        JSONObject extractJson = SchemaSerialization.extractSchema((Schema)schema);
        String transferredString = extractJson.toJSONString();
        JSONObject restoreJson = (JSONObject)JSONValue.parse((String)transferredString);
        return SchemaSerialization.restoreSchemna((JSONObject)restoreJson);
    }
}

