/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.json.util;

import java.util.HashMap;
import java.util.LinkedList;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.json.util.FormSerialization;
import org.apache.sqoop.model.MBooleanInput;
import org.apache.sqoop.model.MEnumInput;
import org.apache.sqoop.model.MForm;
import org.apache.sqoop.model.MIntegerInput;
import org.apache.sqoop.model.MMapInput;
import org.apache.sqoop.model.MStringInput;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.junit.Assert;
import org.junit.Test;

public class TestFormSerialization {
    @Test
    public void testAllDataTypes() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("A", "B");
        MForm form = this.getForm();
        form.getStringInput("String").setValue((Object)"A");
        form.getMapInput("Map").setValue(map);
        form.getIntegerInput("Integer").setValue((Object)1);
        form.getBooleanInput("Boolean").setValue((Object)true);
        form.getEnumInput("Enum").setValue("YES");
        JSONObject jsonObject = FormSerialization.extractForm((MForm)form, (boolean)false);
        Assert.assertNotNull((Object)jsonObject);
        String serializedJson = jsonObject.toJSONString();
        JSONObject retrievedJson = (JSONObject)JSONValue.parse((String)serializedJson);
        MForm retrieved = FormSerialization.restoreForm((JSONObject)retrievedJson);
        Assert.assertEquals((Object)"A", (Object)retrieved.getStringInput("String").getValue());
        Assert.assertEquals(map, (Object)retrieved.getMapInput("Map").getValue());
        Assert.assertEquals((long)1L, (long)((Integer)retrieved.getIntegerInput("Integer").getValue()).intValue());
        Assert.assertEquals((Object)true, (Object)retrieved.getBooleanInput("Boolean").getValue());
        Assert.assertEquals((Object)"YES", (Object)retrieved.getEnumInput("Enum").getValue());
    }

    @Test
    public void testMapDataType() {
        MForm form = this.getMapForm();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("A", "B");
        form.getMapInput("Map").setValue(map);
        JSONObject jsonObject = FormSerialization.extractForm((MForm)form, (boolean)false);
        String serializedJson = jsonObject.toJSONString();
        JSONObject retrievedJson = (JSONObject)JSONValue.parse((String)serializedJson);
        MForm retrieved = FormSerialization.restoreForm((JSONObject)retrievedJson);
        Assert.assertEquals(map, (Object)retrieved.getMapInput("Map").getValue());
    }

    @Test(expected=SqoopException.class)
    public void testMapDataTypeException() {
        MForm form = this.getMapForm();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("A", "B");
        form.getMapInput("Map").setValue(map);
        JSONObject jsonObject = FormSerialization.extractForm((MForm)form, (boolean)false);
        String serializedJson = jsonObject.toJSONString();
        String badSerializedJson = serializedJson.replace("{\"A\":\"B\"}", "\"nonsensical string\"");
        System.out.println(badSerializedJson);
        JSONObject retrievedJson = (JSONObject)JSONValue.parse((String)badSerializedJson);
        FormSerialization.restoreForm((JSONObject)retrievedJson);
    }

    protected MForm getMapForm() {
        LinkedList<MMapInput> inputs = new LinkedList<MMapInput>();
        MMapInput input = new MMapInput("Map", false);
        inputs.add(input);
        return new MForm("f", inputs);
    }

    protected MForm getForm() {
        LinkedList<MStringInput> inputs = new LinkedList<MStringInput>();
        MStringInput input = new MStringInput("String", false, 30);
        inputs.add(input);
        input = new MMapInput("Map", false);
        inputs.add(input);
        input = new MIntegerInput("Integer", false);
        inputs.add(input);
        input = new MBooleanInput("Boolean", false);
        inputs.add(input);
        input = new MEnumInput("Enum", false, new String[]{"YES", "NO"});
        inputs.add(input);
        return new MForm("f", inputs);
    }
}

