/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.json;

import java.util.Date;
import junit.framework.Assert;
import org.apache.sqoop.json.JobBean;
import org.apache.sqoop.json.TestUtil;
import org.apache.sqoop.model.MForm;
import org.apache.sqoop.model.MJob;
import org.apache.sqoop.model.MStringInput;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.ParseException;
import org.junit.Test;

public class TestJobBean {
    @Test
    public void testSerialization() throws ParseException {
        Date created = new Date();
        Date updated = new Date();
        MJob job = TestUtil.getJob("ahoj", MJob.Type.IMPORT);
        job.setName("The big job");
        job.setPersistenceId(666L);
        job.setCreationDate(created);
        job.setLastUpdateDate(updated);
        job.setEnabled(false);
        MStringInput input = (MStringInput)((MForm)job.getConnectorPart().getForms().get(0)).getInputs().get(0);
        input.setValue((Object)"Hi there!");
        JobBean bean = new JobBean(job);
        JSONObject json = bean.extract(false);
        String string = json.toJSONString();
        JSONObject retrievedJson = (JSONObject)JSONValue.parseWithException((String)string);
        JobBean retrievedBean = new JobBean();
        retrievedBean.restore(retrievedJson);
        MJob target = (MJob)retrievedBean.getJobs().get(0);
        Assert.assertEquals((long)666L, (long)target.getPersistenceId());
        Assert.assertEquals((Object)MJob.Type.IMPORT, (Object)target.getType());
        Assert.assertEquals((String)"The big job", (String)target.getName());
        Assert.assertEquals((Object)created, (Object)target.getCreationDate());
        Assert.assertEquals((Object)updated, (Object)target.getLastUpdateDate());
        Assert.assertEquals((boolean)false, (boolean)target.getEnabled());
        MStringInput targetInput = (MStringInput)((MForm)target.getConnectorPart().getForms().get(0)).getInputs().get(0);
        Assert.assertEquals((String)"Hi there!", (String)((String)targetInput.getValue()));
    }
}

