/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.json;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.ResourceBundle;
import org.apache.sqoop.json.ConnectorBean;
import org.apache.sqoop.json.TestUtil;
import org.apache.sqoop.model.MConnector;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.junit.Assert;
import org.junit.Test;

public class TestConnectorBean {
    @Test
    public void testSerialization() {
        LinkedList<MConnector> connectors = new LinkedList<MConnector>();
        connectors.add(TestUtil.getConnector("jdbc"));
        connectors.add(TestUtil.getConnector("mysql"));
        HashMap<Long, ResourceBundle> bundles = new HashMap<Long, ResourceBundle>();
        bundles.put(1L, TestUtil.getResourceBundle());
        bundles.put(2L, TestUtil.getResourceBundle());
        ConnectorBean bean = new ConnectorBean(connectors, bundles);
        JSONObject json = bean.extract(false);
        String string = json.toJSONString();
        JSONObject retrievedJson = (JSONObject)JSONValue.parse((String)string);
        ConnectorBean retrievedBean = new ConnectorBean();
        retrievedBean.restore(retrievedJson);
        Assert.assertEquals((long)connectors.size(), (long)retrievedBean.getConnectors().size());
        Assert.assertEquals(connectors.get(0), retrievedBean.getConnectors().get(0));
        ResourceBundle retrievedBundle = (ResourceBundle)retrievedBean.getResourceBundles().get(1L);
        Assert.assertNotNull((Object)retrievedBundle);
        Assert.assertEquals((Object)"a", (Object)retrievedBundle.getString("a"));
        Assert.assertEquals((Object)"b", (Object)retrievedBundle.getString("b"));
    }
}

