/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.json;

import java.util.Date;
import junit.framework.Assert;
import org.apache.sqoop.json.ConnectionBean;
import org.apache.sqoop.json.TestUtil;
import org.apache.sqoop.model.MConnection;
import org.apache.sqoop.model.MForm;
import org.apache.sqoop.model.MStringInput;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.junit.Test;

public class TestConnectionBean {
    @Test
    public void testSerialization() {
        Date created = new Date();
        Date updated = new Date();
        MConnection connection = TestUtil.getConnection("ahoj");
        connection.setName("Connection");
        connection.setPersistenceId(666L);
        connection.setCreationUser("admin");
        connection.setCreationDate(created);
        connection.setLastUpdateUser("user");
        connection.setLastUpdateDate(updated);
        connection.setEnabled(false);
        MStringInput input = (MStringInput)((MForm)connection.getConnectorPart().getForms().get(0)).getInputs().get(0);
        input.setValue((Object)"Hi there!");
        ConnectionBean bean = new ConnectionBean(connection);
        JSONObject json = bean.extract(false);
        JSONArray all = (JSONArray)json.get((Object)"all");
        JSONObject allItem = (JSONObject)all.get(0);
        JSONArray connectors = (JSONArray)allItem.get((Object)"connector");
        JSONObject connector = (JSONObject)connectors.get(0);
        JSONArray inputs = (JSONArray)connector.get((Object)"inputs");
        for (Object input1 : inputs) {
            Assert.assertTrue((boolean)((JSONObject)input1).containsKey((Object)"sensitive"));
        }
        String string = json.toJSONString();
        JSONObject retrievedJson = (JSONObject)JSONValue.parse((String)string);
        ConnectionBean retrievedBean = new ConnectionBean();
        retrievedBean.restore(retrievedJson);
        MConnection target = (MConnection)retrievedBean.getConnections().get(0);
        Assert.assertEquals((long)666L, (long)target.getPersistenceId());
        Assert.assertEquals((String)"Connection", (String)target.getName());
        Assert.assertEquals((String)"admin", (String)target.getCreationUser());
        Assert.assertEquals((Object)created, (Object)target.getCreationDate());
        Assert.assertEquals((String)"user", (String)target.getLastUpdateUser());
        Assert.assertEquals((Object)updated, (Object)target.getLastUpdateDate());
        Assert.assertEquals((boolean)false, (boolean)target.getEnabled());
        MStringInput targetInput = (MStringInput)((MForm)target.getConnectorPart().getForms().get(0)).getInputs().get(0);
        Assert.assertEquals((String)"Hi there!", (String)((String)targetInput.getValue()));
    }

    @Test
    public void testSensitivityFilter() {
        Date created = new Date();
        Date updated = new Date();
        MConnection connection = TestUtil.getConnection("ahoj");
        connection.setName("Connection");
        connection.setPersistenceId(666L);
        connection.setCreationUser("admin");
        connection.setCreationDate(created);
        connection.setLastUpdateUser("user");
        connection.setLastUpdateDate(updated);
        connection.setEnabled(true);
        MStringInput input = (MStringInput)((MForm)connection.getConnectorPart().getForms().get(0)).getInputs().get(0);
        input.setValue((Object)"Hi there!");
        ConnectionBean bean = new ConnectionBean(connection);
        JSONObject json = bean.extract(false);
        JSONObject jsonFiltered = bean.extract(true);
        JSONArray all = (JSONArray)json.get((Object)"all");
        JSONObject allItem = (JSONObject)all.get(0);
        JSONArray connectors = (JSONArray)allItem.get((Object)"connector");
        JSONObject connector = (JSONObject)connectors.get(0);
        JSONArray inputs = (JSONArray)connector.get((Object)"inputs");
        Assert.assertEquals((int)3, (int)inputs.size());
        JSONObject password = (JSONObject)inputs.get(2);
        Assert.assertTrue((boolean)password.containsKey((Object)"value"));
        all = (JSONArray)jsonFiltered.get((Object)"all");
        allItem = (JSONObject)all.get(0);
        connectors = (JSONArray)allItem.get((Object)"connector");
        connector = (JSONObject)connectors.get(0);
        inputs = (JSONArray)connector.get((Object)"inputs");
        Assert.assertEquals((int)3, (int)inputs.size());
        password = (JSONObject)inputs.get(2);
        Assert.assertFalse((boolean)password.containsKey((Object)"value"));
    }
}

