/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.common.test.utils;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;

public class NetworkUtils {
    private static final Logger LOG = Logger.getLogger(NetworkUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int findAvailablePort() throws IOException {
        ServerSocket socket = null;
        try {
            socket = new ServerSocket(0);
            int n = socket.getLocalPort();
            return n;
        }
        finally {
            if (socket != null) {
                socket.close();
            }
        }
    }

    public static void waitForStartUp(String hostname, int port, int numberOfAttempts, long sleepTime) throws InterruptedException, TimeoutException {
        for (int i = 0; i < numberOfAttempts; ++i) {
            try {
                LOG.debug((Object)("Attempt " + (i + 1) + " to access " + hostname + ":" + port));
                new Socket(InetAddress.getByName(hostname), port).close();
                return;
            }
            catch (Exception e) {
                LOG.debug((Object)("Failed to connect to " + hostname + ":" + port), (Throwable)e);
                Thread.sleep(sleepTime);
                continue;
            }
        }
        throw new TimeoutException("Couldn't access new server: " + hostname + ":" + port);
    }

    private NetworkUtils() {
    }
}

